package diamond_e

import "git.hilo.cn/hilo-common/resource/mysql"

type StatusAccount = mysql.Type

const (
	Normal StatusAccount = 1
	//冻结，只是限制减少，不限制增加
	Frozen StatusAccount = 2
)

type OperateType = mysql.Type

const (
	//注册
	/*	REGISTER OperateType = 1
		//建立融云会话
		SessionPay OperateType = 2
		//购买钻石
		BuyDiamond OperateType = 3
		//发送礼物
		SendGift OperateType = 4
		//接受礼物
		ReceiveGift OperateType = 5
		//匹配条件
		MatchCondition OperateType = 6*/

	SendGift                   OperateType = 1   //发送礼物
	MatchCondition             OperateType = 2   //匹配条件
	SessionPay                 OperateType = 3   //建立融云会话
	BuyDiamond                 OperateType = 4   //购买钻石
	ReceiveGift                OperateType = 5   //接受礼物
	REGISTER                   OperateType = 6   //注册
	MgrSend                    OperateType = 8   //平台赠送
	VideoCost                  OperateType = 9   //1对1视频花费
	MgrReduce                  OperateType = 10  //平台扣除
	ActivityBillboard          OperateType = 11  //活动榜单奖励
	ExchangeBean               OperateType = 12  //钻石兑换豆子
	ActivityGroupBillboard     OperateType = 13  //活动榜单奖励
	DailyInAppVip              OperateType = 14  //每日登陆领取钻石(VIP)
	GroupIMMass                OperateType = 15  //群中IM群发
	DailyInAppCommon           OperateType = 16  //每日登陆领取钻石(普通用户)
	GroupSupportAdmin          OperateType = 17  //群组支持(利益分配者)
	GroupSupportMgr            OperateType = 18  //群主支持（助手）
	MgrBillDiamond             OperateType = 19  //管理人单据送钻石
	Headwear                   OperateType = 20  //送头饰扣费
	Property                   OperateType = 21  //送坐骑扣费
	LuckyWheelJoin             OperateType = 22  //参与转盘扣费
	LuckyWheelCancel           OperateType = 23  //转盘取消
	LuckyWheelWin              OperateType = 24  //转盘奖励
	LuckWheelGroupOwer         OperateType = 25  //转盘群主抽成
	DealerTransfer             OperateType = 26  //币商转账
	GroupCustomTheme           OperateType = 27  //购买群组自定义主题
	RocketAward                OperateType = 28  //火箭奖励
	LuckyboxBuy                OperateType = 29  //幸运盒子购买
	LuckyboxAward              OperateType = 30  //幸运盒子奖励
	PrivateGift                OperateType = 31  // 私聊送礼物
	PrivateGiftReturn          OperateType = 32  // 私聊送礼物退款
	ActivityTriggerAward       OperateType = 33  //活动触发奖励
	VideoTradeUnionGift        OperateType = 34  // 视频送礼物
	VideoTradeUnionGiftReturn  OperateType = 35  // 视频送礼物退款
	GlobalBroadcast            OperateType = 36  //全球发布消息
	TaskAward                  OperateType = 37  //任务奖励
	FruitMachineAward          OperateType = 38  // 水果机奖励
	FruitMachineBet            OperateType = 39  // 水果机投注
	Noble                      OperateType = 40  //购买/赠送贵族
	FruitTycoonAward           OperateType = 41  // 水果大亨奖励
	Checkout                   OperateType = 42  //checkout购买
	LuckyboxCycle              OperateType = 43  //幸运盒子回收奖励
	ActivityRechargeFirst      OperateType = 44  //首次充值奖励
	NewUserInvite              OperateType = 45  // 新用户奖励活动
	GeneralActivity            OperateType = 46  // 一般性活动奖励
	PowerSupportOwner          OperateType = 47  // 势力支持(势力主)
	PowerSupportAssistant      OperateType = 48  // 势力支持（助手）
	VideoMinute                OperateType = 49  //1对1视频（分钟扣费）
	MatchMinute                OperateType = 50  //匹配视频（第一分钟扣费）
	VideoMinuteBack            OperateType = 51  //1对1视频（分钟扣费，返回）
	VideoMinuteTotal           OperateType = 52  //1对1视频（分钟扣费，返回）
	GroupActivity              OperateType = 53  //创建群组活动
	GroupActivityReward        OperateType = 54  //群组活动奖励
	PayerMax                   OperateType = 55  //payerMax/茄子支付购买
	BuyPinkDiamond             OperateType = 56  //购买粉钻
	VideoCostPink              OperateType = 57  //1对1视频送礼(粉钻)
	MatchMinutePink            OperateType = 58  //匹配视频（第一分钟扣费）(粉钻)
	VideoMinuteTotalPink       OperateType = 59  //1对1视频（分钟扣费，返回）(粉钻)
	SendPinkGift               OperateType = 60  //送粉钻礼物 ---占位---暂不开放 数据库配置表中暂未配置
	MatchMinuteGiftPink        OperateType = 61  //匹配视频送礼(粉钻)
	MatchMinuteGiftPinkTime    OperateType = 62  //匹配视频加时送礼(粉钻)
	JoinGroupCost              OperateType = 63  //加入群组扣费
	JoinGroupAdd               OperateType = 64  //加入群组,群主得黄钻
	GameJoin                   OperateType = 65  //加入游戏扣费
	GameAward                  OperateType = 66  //游戏结算奖励
	GameRefund                 OperateType = 67  //游戏退费
	Paypal                     OperateType = 68  //paypal充值
	H5GameSlotJoin             OperateType = 69  //加入游戏扣费
	H5GameSlotAward            OperateType = 70  //游戏结算奖励
	ActFruitPutRankAward       OperateType = 71  //水果机排行榜奖励
	H5GameSlotLevelAward       OperateType = 72  //游戏等级奖励
	ActSlotWeekRankAward       OperateType = 75  //slot周活动排行榜奖励
	ActSlotWeekDailyAward      OperateType = 76  //slot周活动每日福利奖励
	ActFruitWeekDailyAward     OperateType = 78  //水果机周活动每日福利奖励
	ActSlotMonthAward          OperateType = 79  //slot月度活动奖励
	H5GameCandyJoin            OperateType = 80  //加入游戏扣费
	H5GameCandyAward           OperateType = 81  //游戏结算奖励
	H5GameCandyLevelAward      OperateType = 82  //游戏等级奖励
	H5GameSlotStageAward       OperateType = 83  //slot阶梯奖励
	H5GameCandyStageAward      OperateType = 84  //candy阶梯奖励
	H5GameGreedyJoin           OperateType = 85  //加入游戏扣费
	H5GameGreedyAward          OperateType = 86  //游戏结算奖励
	H5GameGreedyLevelAward     OperateType = 87  //游戏等级奖励
	ActCandyWeekRankAward      OperateType = 88  //candy周活动排行榜奖励
	ActCandyWeekDailyAward     OperateType = 89  //candy周活动每日福利奖励
	GemToDiamondYellow         OperateType = 90  //粉钻转黄钻(黄钻)
	GemToDiamondPink           OperateType = 91  //粉钻转黄钻(粉钻)
	ActGreedyMonthAward        OperateType = 93  //greedy月度活动奖励
	CpInvite                   OperateType = 94  //cp邀请扣费
	CpInviteRefund             OperateType = 95  //cp邀请退费
	ActGameCharge              OperateType = 96  //游戏充值档位活动
	H5GameWheelJoin            OperateType = 97  //wheel加入游戏扣费
	H5GameWheelAward           OperateType = 98  //wheel游戏结算奖励
	H5GameWheelLevelAward      OperateType = 99  //wheel游戏等级奖励
	H5GameFruitSlotsJoin       OperateType = 100 //fruitSlots加入游戏扣费
	H5GameFruitSlotsAward      OperateType = 101 //fruitSlots游戏结算奖励
	H5GameFruitSlotsLevelAward OperateType = 102 //fruitSlots游戏等级奖励
	H5GameFishLordJoin         OperateType = 103 //fishLord加入游戏扣费
	H5GameFishLordAward        OperateType = 104 //fishLord游戏结算奖励
	H5GameFishLordLevelAward   OperateType = 105 //fishLord游戏等级奖励
	H5GameGameSlotJoin         OperateType = 106 //gameSlot加入游戏扣费
	H5GameGameSlotAward        OperateType = 107 //gameSlot游戏结算奖励
	H5GameGameSlotLevelAward   OperateType = 108 //gameSlot游戏等级奖励
	GeneralActivityGem         OperateType = 109 //一般性活动奖励(粉钻)
	DiamondToGemReduceYellow   OperateType = 111 //黄钻转粉钻(黄钻减少)
	DiamondToGemAddPink        OperateType = 112 //黄钻转粉钻(粉钻增加)
)

const (
	DiamondYellow mysql.Type = 1
	DiamondPink   mysql.Type = 2
)

// 归入充值的类型
var ChargeTypes = []int{int(BuyDiamond), int(Checkout), int(PayerMax), int(Paypal)}
