package rpc

import (
	"encoding/json"
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/consul"
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/hashicorp/consul/api"
	"math/rand"
)

const (
	defaultGroupConsulName   = "hiloGroup"
	defaultGroupServerScheme = "http"
	defaultGroupServerAddr   = "127.0.0.1:9050" // 默认内网转发,本地回环
)

var groupServerHost = []string{defaultGroupServerAddr}

func init() {
	go func() {
		address := api.DefaultConfig().Address // 用consul api的default config
		if err := consul.RegisterWatcher("services", nil, address, func(serviceStatus map[string]map[string][]string) {
			if statusAddrs, ok := serviceStatus[defaultGroupConsulName]; ok {
				healthAddrs, _ := statusAddrs[api.HealthPassing]
				l := len(healthAddrs)
				if l > 0 {
					mylogrus.MyLog.Infof("consul service update state:%v-%v", defaultGroupConsulName, healthAddrs)
					groupServerHost = healthAddrs
				} else {
					mylogrus.MyLog.Warnf("consul service update local state:%v-%v", defaultFinanceConsulName, defaultFinanceServerAddr)
					groupServerHost = []string{defaultGroupServerAddr} // 有其他问题都用默认的
				}
				for status := range statusAddrs {
					if status == api.HealthPassing {
						continue
					}
					mylogrus.MyLog.Warnf("consul service wrong state:%v-%v-%v", defaultGroupConsulName, status, statusAddrs[status])
				}
			}
		}); err != nil {
			mylogrus.MyLog.Errorf("启动 consul 的watch监控失败")
		}
	}()
}

// 家族信息
type CvGroupPowerInfo struct {
	CvGroupPowerBase   `json:",inline"`
	CvGroupPowerMember `json:",inline"`
	CvGroupPowerGrade  `json:",inline"`
}

// 家族基本信息
type CvGroupPowerBase struct {
	Id        mysql.ID `json:"id"`        // 家族id
	Icon      string   `json:"icon"`      // 家族图片
	Name      string   `json:"name"`      // 家族名
	Nameplate string   `json:"nameplate"` // 铭牌
}

// 家族成员
type CvGroupPowerMember struct {
	MemberNum mysql.Num `json:"memberNum"` // 当前成员数
	MemberMax mysql.Num `json:"memberMax"` // 成员上限
}

// 家族等级
type CvGroupPowerGrade struct {
	Grade    int    `json:"grade"`              // 等级 0:无 1:青铜 2:白银 3:黄金 4:黑金
	Exp      uint32 `json:"exp"`                // 经验值
	NextExp  uint32 `json:"nextExp,omitempty"`  // 升级所需经验值
	ExpireAt string `json:"expireAt,omitempty"` // 有效期
	ShowExp  bool   `json:"showExp"`            // 是否展示经验值
}

// 获取家族
func GetGroupPower(model *domain.Model, groupPowerId mysql.ID) (CvGroupPowerInfo, error) {
	infos, err := MGetGroupPower(model, []mysql.ID{groupPowerId})
	if err != nil {
		return CvGroupPowerInfo{}, nil
	}
	return infos[groupPowerId], nil
}

// 批量获取家族
func MGetGroupPower(model *domain.Model, groupPowerIds []mysql.ID) (map[mysql.ID]CvGroupPowerInfo, error) {
	type Response struct {
		Code    int    `json:"code"`
		Message string `json:"message"`
		Data    map[mysql.ID]CvGroupPowerInfo
	}
	var res = make(map[mysql.ID]CvGroupPowerInfo)
	if len(groupPowerIds) <= 0 {
		return res, nil
	}
	var idsStr []string
	for _, userId := range groupPowerIds {
		idsStr = append(idsStr, fmt.Sprintf("%d", userId))
	}
	_url := fmt.Sprintf("%v://%v/inner/groupPower/infos", defaultGroupServerScheme, getGroupHost())
	resp, err := HttpGet(model, _url, nil, map[string][]string{
		"ids": idsStr,
	})
	if err != nil {
		model.Log.Errorf("MGetGroupPower fail:%v", err)
		return res, err
	}
	response := new(Response)
	if err = json.Unmarshal(resp, response); err != nil {
		model.Log.Errorf("MGetUserSvip json fail:%v", err)
		return res, err
	}
	res = response.Data
	return res, nil
}

func getGroupHost() string {
	l := len(groupServerHost)
	r := rand.Intn(l) // 随机一个
	mylogrus.MyLog.Infof("getHostGroup:%v---%v", r, groupServerHost[r])
	return groupServerHost[r]
}
