package diamond_e

import "git.hilo.cn/hilo-common/resource/mysql"

type StatusAccount = mysql.Type

const (
	Normal StatusAccount = 1
	//冻结，只是限制减少，不限制增加
	Frozen StatusAccount = 2
)

type OperateType = mysql.Type

const (
	//注册
	/*	REGISTER OperateType = 1
		//建立融云会话
		SessionPay OperateType = 2
		//购买钻石
		BuyDiamond OperateType = 3
		//发送礼物
		SendGift OperateType = 4
		//接受礼物
		ReceiveGift OperateType = 5
		//匹配条件
		MatchCondition OperateType = 6*/

	SendGift                  OperateType = 1  //发送礼物
	MatchCondition            OperateType = 2  //匹配条件
	SessionPay                OperateType = 3  //建立融云会话
	BuyDiamond                OperateType = 4  //购买钻石
	ReceiveGift               OperateType = 5  //接受礼物
	REGISTER                  OperateType = 6  //注册
	MgrSend                   OperateType = 8  //平台赠送
	VideoCost                 OperateType = 9  //1对1视频花费
	MgrReduce                 OperateType = 10 //平台扣除
	ActivityBillboard         OperateType = 11 //活动榜单奖励
	ExchangeBean              OperateType = 12 //钻石兑换豆子
	ActivityGroupBillboard    OperateType = 13 //活动榜单奖励
	DailyInAppVip             OperateType = 14 //每日登陆领取钻石(VIP)
	GroupIMMass               OperateType = 15 //群中IM群发
	DailyInAppCommon          OperateType = 16 //每日登陆领取钻石(普通用户)
	GroupSupportAdmin         OperateType = 17 //群组支持(利益分配者)
	GroupSupportMgr           OperateType = 18 //群主支持（助手）
	MgrBillDiamond            OperateType = 19 //管理人单据送钻石
	Headwear                  OperateType = 20 //送头饰扣费
	Property                  OperateType = 21 //送坐骑扣费
	LuckyWheelJoin            OperateType = 22 //参与转盘扣费
	LuckyWheelCancel          OperateType = 23 //转盘取消
	LuckyWheelWin             OperateType = 24 //转盘奖励
	LuckWheelGroupOwer        OperateType = 25 //转盘群主抽成
	DealerTransfer            OperateType = 26 //币商转账
	GroupCustomTheme          OperateType = 27 //购买群组自定义主题
	RocketAward               OperateType = 28 //火箭奖励
	LuckyboxBuy               OperateType = 29 //幸运盒子购买
	LuckyboxAward             OperateType = 30 //幸运盒子奖励
	PrivateGift               OperateType = 31 // 私聊送礼物
	PrivateGiftReturn         OperateType = 32 // 私聊送礼物退款
	ActivityTriggerAward      OperateType = 33 //活动触发奖励
	VideoTradeUnionGift       OperateType = 34 // 视频送礼物
	VideoTradeUnionGiftReturn OperateType = 35 // 视频送礼物退款
	GlobalBroadcast           OperateType = 36 //全球发布消息
	TaskAward                 OperateType = 37 //任务奖励
	FruitMachineAward         OperateType = 38 // 水果机奖励
	FruitMachineBet           OperateType = 39 // 水果机投注
	Noble                     OperateType = 40 //购买/赠送贵族
	FruitTycoonAward          OperateType = 41 // 水果大亨奖励
	Checkout                  OperateType = 42 //checkout购买
	LuckyboxCycle             OperateType = 43 //幸运盒子回收奖励
	ActivityRechargeFirst     OperateType = 44 //首次充值奖励
	NewUserInvite             OperateType = 45 // 新用户奖励活动
	GeneralActivity           OperateType = 46 // 一般性活动奖励
	PowerSupportOwner         OperateType = 47 // 势力支持(势力主)
	PowerSupportAssistant     OperateType = 48 // 势力支持（助手）
	VideoMinute               OperateType = 49 //1对1视频（分钟扣费）
	MatchMinute               OperateType = 50 //匹配视频（第一分钟扣费）
	VideoMinuteBack           OperateType = 51 //1对1视频（分钟扣费，返回）
	VideoMinuteTotal          OperateType = 52 //1对1视频（分钟扣费，返回）
	GroupActivity             OperateType = 53 //创建群组活动
	GroupActivityReward       OperateType = 54 //群组活动奖励
	PayerMax                  OperateType = 55 //payerMax/茄子支付购买
	BuyPinkDiamond            OperateType = 56 //购买粉钻
	VideoCostPink             OperateType = 57 //1对1视频送礼(粉钻)
	MatchMinutePink           OperateType = 58 //匹配视频（第一分钟扣费）(粉钻)
	VideoMinuteTotalPink      OperateType = 59 //1对1视频（分钟扣费，返回）(粉钻)
	SendPinkGift              OperateType = 60 //送粉钻礼物 ---占位---暂不开放 数据库配置表中暂未配置
	MatchMinuteGiftPink       OperateType = 61 //匹配视频送礼(粉钻)
	MatchMinuteGiftPinkTime   OperateType = 62 //匹配视频加时送礼(粉钻)
	JoinGroupCost             OperateType = 63 //加入群组扣费
	JoinGroupAdd              OperateType = 64 //加入群组,群主得黄钻
	GameJoin                  OperateType = 65 //加入游戏扣费
	GameAward                 OperateType = 66 //游戏结算奖励
	GameRefund                OperateType = 67 //游戏退费
	Paypal                    OperateType = 68 //paypal充值
	H5GameJoin                OperateType = 69 //加入游戏扣费
	H5GameAward               OperateType = 70 //游戏结算奖励
	ActFruitPutRankAward      OperateType = 71 //水果机排行榜奖励
	H5GameLevelAward          OperateType = 72 //游戏等级奖励
	ActSlotWeekRankAward      OperateType = 73 //slot周活动排行榜奖励
)

const (
	DiamondYellow mysql.Type = 1
	DiamondPink   mysql.Type = 2
)
