package award_tx

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/internal/enum/diamond_e"
	"git.hilo.cn/hilo-common/internal/enum/msg_e"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/txop/diamond_tx"
	"git.hilo.cn/hilo-common/txop/headwear_tx"
	"git.hilo.cn/hilo-common/txop/medal_tx"
	"git.hilo.cn/hilo-common/txop/noble_tx"
	"git.hilo.cn/hilo-common/txop/ride_tx"
)

type UserAward struct {
	UserId            uint64
	ActivityId        uint64
	NobleLevel        mysql.Num
	NobleDuration     mysql.Num //单位(天）
	Diamond           mysql.Num
	PropertyId        mysql.ID
	PropertyDuration  mysql.NumAll //单位(天）
	HeaddressId       mysql.ID
	HeaddressDuration mysql.NumAll //单位(天）
	MedalId           mysql.ID
	MedalDuration     mysql.Num //单位(天）
	NameplateId       mysql.ID
	NameplateDuration mysql.Num //单位(天）
}

func SendUserAward(txModel *domain.Model, award *UserAward, opt diamond_e.OperateType, msgType ...msg_e.MsgUserRecordType) (err error) {
	if award.UserId <= 0 {
		return
	}
	if award.Diamond > 0 {
		err = diamond_tx.SendDiamond(txModel, award.UserId, opt, award.ActivityId, award.Diamond, msgType...)
		if err != nil {
			return
		}
	}
	if award.NobleDuration > 0 && award.NobleLevel > 0 {
		err = noble_tx.SendNoble(txModel, award.UserId, uint16(award.NobleLevel), int(award.NobleDuration))
		if err != nil {
			return
		}
	}
	if award.PropertyId > 0 && award.PropertyDuration > 0 {
		err = ride_tx.SendRide(txModel, award.UserId, award.PropertyId, award.PropertyDuration)
		if err != nil {
			return
		}
	}
	if award.HeaddressId > 0 && award.HeaddressDuration > 0 {
		err = headwear_tx.SendHeadwear(txModel, award.UserId, award.HeaddressId, award.HeaddressDuration)
		if err != nil {
			return
		}
	}
	if award.MedalId > 0 && award.MedalDuration > 0 {
		err = medal_tx.SendMedal(txModel, award.UserId, award.MedalId, int(award.MedalDuration))
		if err != nil {
			return
		}
	}
	return
}
