package bag_tx

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/internal/enum/msg_e"
	"git.hilo.cn/hilo-common/internal/model/bag_m"
	"git.hilo.cn/hilo-common/internal/model/msg_m"
	"git.hilo.cn/hilo-common/internal/model/res_m"
	"git.hilo.cn/hilo-common/internal/model/user_m"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm/clause"
	"time"
)

// 增加用户背包
// param userId 用户id
// param resType 道具类型
// param resId 道具id
// param count 增加数量
// param day 增加天数
// condition:
//	0.事务操作,依赖外面传进来的model
//  1.背包表
//  2.明细表
// return bagId
func SendUserBag(txModel *domain.Model, userId mysql.ID, resType mysql.Type, resId mysql.ID, count mysql.Num, day int, reason string) (mysql.ID, error) {
	var bagId mysql.ID
	//  1.背包表
	endTime := time.Now().AddDate(0, 0, day)
	userBag := &bag_m.UserBag{
		UserId:  userId,
		ResType: resType,
		ResId:   resId,
		Count:   count,
		EndTime: endTime,
	}
	if err := txModel.DB().Clauses(clause.OnConflict{
		Columns:   []clause.Column{{Name: "user_id"}, {Name: "res_type"}, {Name: "res_id"}, {Name: "end_time"}},
		DoUpdates: clause.AssignmentColumns([]string{"count"}),
	}).Create(userBag).Error; err != nil {
		return 0, err
	}
	bagId = userBag.ID // 自增id
	//  2.明细表
	userBagDetail := &bag_m.UserBagDetail{
		UserId:    userId,
		BagId:     userBag.ID,
		ResType:   resType,
		ResId:     resId,
		Count:     count,
		AddReduce: mysql.ADD,
		BefNum:    0,     // 加背包的统一为0
		AftNum:    count, // 加背包统一为count,因为每次加几乎不可能是一样的
		Remark:    reason,
	}
	if err := txModel.DB().Create(userBagDetail).Error; err != nil {
		return 0, err
	}
	// 小助手通知
	go func() {
		model := domain.CreateModelContext(txModel.MyContext)
		user, err := user_m.GetUser(model, userId)
		if err != nil {
			model.Log.Errorf("user_m.GetUser fail:%v", err)
			return
		}
		gift, err := res_m.FindResGift(model, resId)
		if err != nil {
			model.Log.Errorf("res_m.FindResGift fail:%v", err)
			return
		}
		if err := msg_m.NewUserRecord(model, userId, msg_e.AddUserBag,
			gift.Name, 0, "", fmt.Sprintf("%d", day),
			"", "", "").Persistent(); err != nil {
			model.Log.Errorf("NewUserRecord fail")
		} else {
			if err := msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType); err != nil {
				model.Log.Errorf("SendEmasMsgAssistant fail:%v", err)
			}
		}
	}()
	return bagId, nil
}
