package diamond_tx

import (
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/internal/enum/diamond_e"
	"git.hilo.cn/hilo-common/internal/enum/msg_e"
	"git.hilo.cn/hilo-common/internal/model/diamond_m"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/txop/msg"
)

// 下发钻石
func SendDiamond(model *domain.Model, userId mysql.ID, opt diamond_e.OperateType, originId mysql.ID, diamondNum mysql.Num,
	msgType ...msg_e.MsgUserRecordType) error {
	diamondAccount, err := diamond_m.GetDiamondAccountByUserId(model, userId)
	if err != nil {
		return err
	}
	diamondSendAccountDetail, err := diamondAccount.AddDiamondAccountDetail(opt, originId, diamondNum)
	if err != nil {
		return err
	}
	if err := diamondSendAccountDetail.Persistent(); err != nil {
		return err
	}
	if len(msgType) > 0 {
		// 小助手提示获得钻石
		msg.SendLittleAssistantMsg(model, userId, msgType[0], fmt.Sprintf("%d", diamondNum), "", "", "", "")
	}
	return nil
}
