package user_m

import (
	"context"
	"fmt"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mylogrus"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/resource/redisCli"
	"git.hilo.cn/hilo-common/utils"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
	"time"
)

//用户道具
type UserMedal struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	MedalId       uint32
	//MedalType     res_m2.ResMedalType
	//Scope         res_m2.ResMedalScope
	EndTime *time.Time
}

func (um *UserMedal) Create(db *gorm.DB, day int) error {
	err := db.Clauses(clause.OnConflict{
		DoUpdates: clause.Assignments(map[string]interface{}{
			"end_time": gorm.Expr("DATE_ADD(GREATEST(end_time,NOW()), INTERVAL ? DAY);", day)}),
	}).Create(um).Error
	// 删除勋章缓存, 延迟删除
	DelUserMedalMergeCacheDelay(um.UserId)
	return err
}

// 删除勋章缓存, 延迟删除
func DelUserMedalMergeCacheDelay(userId mysql.ID) {
	go func() {
		defer utils.CheckGoPanic()
		time.Sleep(time.Second * 5)
		DelUserMedalMergeCache(userId)
	}()
}
func DelUserMedalMergeCache(userId mysql.ID) error {
	err := DelCache(getUserMedalMergeKey(userId))
	if err != nil {
		mylogrus.MyLog.Errorf("DetUserMedalMerge err:%s, userId:%v", err, userId)
		return err
	}
	return nil
}

const userMedalMerge = "user:medalMerge:%d" // 勋章

func getUserMedalMergeKey(userId uint64) string {
	return fmt.Sprintf(userMedalMerge, userId)
}

func DelCache(key string) error {
	err := redisCli.GetRedis().Del(context.Background(), key).Err()
	if err != nil {
		mylogrus.MyLog.Errorf("DelCache key:%s, err:%s", key, err)
		return err
	}
	return nil
}
