package main

import (
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
)

type UserSvip struct {
	UserId   uint64
	Code     string
	Points   int64
	Level    int
	AcPoints int64
	Diamond  int64
}

var bt1 = "2023-01-04 16:42:58"
var et1 = "2023-03-04 00:00:00"

func cal(level int) int64 {
	switch level {
	case 1:
		return 50000
	case 2:
		return 300000
	case 3:
		return 1000000
	case 4:
		return 2000000
	case 5:
		return 5000000
	case 6:
		return 10000000
	case 7:
		return 30000000
	}
	return 0
}

func main() {
	var userSvip []UserSvip
	if err := mysql.ProdReadOnlyDB.Model(UserSvip{}).Where("level > 0").Find(&userSvip).Error; err != nil {
		panic(err)
	}
	for i, v := range userSvip {
		_, userSvip[i].Diamond, _ = GetChargeMoneyDiamond2(v.UserId)
		userSvip[i].AcPoints = v.Points + cal(v.Level)
		var user model.User
		if err := mysql.ProdReadOnlyDB.Model(model.User{}).Where("id = ? ", v.UserId).First(&user).Error; err != nil {
			panic(err)
		}
		userSvip[i].Code = user.Code
	}
	fmt.Printf("UserId,Points,Level,AcPoints,Diamond\n")
	for _, v := range userSvip {
		fmt.Printf("%v,%v,%v,%v,%v\n", v.Code, v.Points, v.Level, v.AcPoints, v.Diamond)
	}
}

func GetChargeMoneyDiamond2(uid uint64) (int64, int64, error) {
	type R struct {
		Money   int64
		Diamond int64
	}
	var money R
	if err := mysql.ProdReadOnlyDB.Table("diamond_account_detail AS d").
		Joins("INNER JOIN pay_order AS p ON d.origin_id = p.id").
		Where("d.user_id in (?) AND operate_type in (?) AND add_reduce = 1",
			uid, []int{int(4), int(42), int(55), int(68)}).
		Where("d.created_time >= ? AND d.created_time < ?", bt1, et1).
		Order("d.user_id").
		Select("SUM(p.price) as money,SUM(d.num) as diamond").Scan(&money).Error; err != nil {
		return 0, 0, err
	}
	type R2 struct {
		Price   int64
		Diamond int64
	}
	var money2 R2
	if err := mysql.ProdReadOnlyDB.Table("diamond_account_detail AS d").
		Joins("INNER JOIN dealer_transfer_detail AS t ON d.origin_id = t.id").
		Where("d.user_id in (?) AND operate_type = ? AND add_reduce = 1",
			uid, 26).Select("SUM(t.dollar) as price,SUM(d.num) as diamond").
		Where("d.created_time >= ? AND d.created_time < ?", bt1, et1).
		Order("d.user_id").
		Scan(&money2).Error; err != nil {
		return 0, 0, err
	}
	return money.Money + money2.Price, money.Diamond + money2.Diamond, nil
}
