package main

import (
	"encoding/json"
	"fmt"
	"git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"github.com/tealeg/xlsx"
	"gorm.io/gorm"
	"io/ioutil"
	"net/http"
)

type GroupPowerUser2 struct {
	GroupPowerId uint64
	UserId       uint64
	Role         int
}

type GroupPowerRankData struct {
	Rank    int    // 家族排名
	Consume uint64 // 周流水
	Code    string // 家族长ID
	Country string // 家族长国家
	Svip    int    // 家族长SVIP等级
	MemNum  int    // 家族人数
}

func ats4(a interface{}) string {
	return fmt.Sprintf("%d", a)
}

func main() {
	httpData := HttpGet()
	var data []GroupPowerRankData
	for i, r := range httpData {
		admin := new(GroupPowerUser2)
		if err := mysql.ProdReadOnlyDB.Table("group_power_user").Where("group_power_id = ? AND role = 2", r.GroupPowerId).First(admin).Error; err != nil {
			panic(err)
		}
		adminUser := new(model.User)
		if err := mysql.ProdReadOnlyDB.Table("user").Where("id = ?", admin.UserId).First(adminUser).Error; err != nil {
			panic(err)
		}
		svip := 0
		userSvip := new(model.UserSvip)
		if err := mysql.ProdReadOnlyDB.Table("user_svip").Where("user_id = ?", admin.UserId).First(&userSvip).Error; err != nil {
			if err != gorm.ErrRecordNotFound {
				panic(err)
			}
		} else {
			svip = userSvip.Level
		}
		data = append(data, GroupPowerRankData{
			Rank:    i + 1,
			Consume: r.DiamondNum,
			Code:    adminUser.Code,
			Country: adminUser.Country,
			Svip:    svip,
			MemNum:  r.UserN,
		})
	}
	excelFileName := fmt.Sprintf("./家族这周流水.xlsx")
	xlFile := xlsx.NewFile()
	sheet, _ := xlFile.AddSheet("charge")
	row := sheet.AddRow()
	c1, c2, c3, c4, c5, c6 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
	c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value =
		"上周家族排名", "周流水", "家族长ID", "家族长国家", "家族长SVIP", "家族人数"
	for _, d := range data {
		row := sheet.AddRow()
		c1, c2, c3, c4, c5, c6 := row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell(), row.AddCell()
		c1.Value, c2.Value, c3.Value, c4.Value, c5.Value, c6.Value =
			ats4(d.Rank), ats4(d.Consume), d.Code, d.Country, ats4(d.Svip), ats4(d.MemNum)
	}
	_ = xlFile.Save(excelFileName)
}

type Data struct {
	GroupPowerId uint64 `json:"groupPowerId"`
	DiamondNum   uint64 `json:"diamondNum"`
	UserN        int    `json:"userN"`
}

type Response struct {
	Data []Data
}

func HttpGet() []Data {
	var result []Data
	url := "https://apiv1.faceline.live/v1/groupPower/billboard/week?type=2&pageIndex=1&pageSize=1000"
	method := "GET"

	client := &http.Client{}
	req, err := http.NewRequest(method, url, nil)

	if err != nil {
		fmt.Println(err)
		return result
	}
	req.Header.Add("token", "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJVc2VySWQiOjQ0NzA0OTEsIkV4dGVybmFsSWQiOiJjZDE5NmRjNDc1NTM0MWMzOWQwZmUyODdjMjc0NWJlMiIsImV4cCI6MTY4MTIyMjcwNSwiaXNzIjoiaGlsb0FwaSJ9.emZc2kTDMpZaqdHVWiF1cFOAfAd0nT3yCSwFw8U_fXA")
	req.Header.Add("nonce", "hilo")

	res, err := client.Do(req)
	if err != nil {
		fmt.Println(err)
		return result
	}
	defer res.Body.Close()

	body, err := ioutil.ReadAll(res.Body)
	if err != nil {
		fmt.Println(err)
		return result
	}
	r := new(Response)
	err = json.Unmarshal(body, r)
	if err != nil {
		panic(err)
	}
	return r.Data
}
