package main

import (
	"git.hilo.cn/hilo-common/script/mysql"
	"time"
)

type FruitDayRank struct {
	Period string
	UserId uint64
	Stake  int64
	Award  int64
}

type FruitMachineStake struct {
	Date   string
	UserId uint64
	Stake  int64
}

type FruitMachineAward struct {
	Date   string
	UserId uint64
	Award  int64
}

func main() {
	start := time.Date(2023, time.January, 1, 0, 0, 0, 0, time.Local)
	for start.Before(time.Now()) {
		var rows []FruitMachineStake
		if err := mysql.ProdReadOnlyDB.Table("fruit_machine_stake").Where("`date` = ?", start.Format("2006-01-02")).
			Select("`date`,user_id,SUM(stake) stake").Group("`date`,user_id").Find(&rows).Error; err != nil {
			panic(err)
		}
		for _, row := range rows {
			if err := mysql.ProdWriteDB.Create(FruitDayRank{
				Period: row.Date,
				UserId: row.UserId,
				Stake:  row.Stake,
				Award:  0,
			}).Error; err != nil {
				panic(err)
			}
		}
		var rows2 []FruitMachineAward
		if err := mysql.ProdReadOnlyDB.Table("fruit_machine_player").Where("`date` = ?", start.Format("2006-01-02")).
			Select("`date`,user_id,SUM(award) award").Group("`date`,user_id").Find(&rows2).Error; err != nil {
			panic(err)
		}
		for _, row := range rows2 {
			if err := mysql.ProdWriteDB.Table("fruit_day_rank").Where("period = ? AND user_id = ?", start.Format("2006-01-02"), row.UserId).
				Update("award", row.Award).Error; err != nil {
				panic(err)
			}
		}
		start = start.AddDate(0, 0, 1)
	}
}
