package main

import (
	"fmt"
	model2 "git.hilo.cn/hilo-common/script/model"
	"git.hilo.cn/hilo-common/script/mysql"
	"time"
)

func main() {
	type GroupConsume struct {
		GroupId string
		Total   int
	}
	type UpdateGroupCode struct {
		GroupId string
		OldCode string
		NewCode string
	}
	var updates []UpdateGroupCode
	var rows []GroupConsume
	sql := "SELECT group_id,SUM(diamond) AS total FROM `room_month_consume` group by group_id HAVING total > 1000000;"
	if err := mysql.ProdReadOnlyDB.Raw(sql).Find(&rows).Error; err != nil {
		panic(err)
	}
	for _, row := range rows {
		groupInfo := new(model2.GroupInfo)
		if err := mysql.ProdReadOnlyDB.Model(model2.GroupInfo{}).Where("im_group_id = ?", row.GroupId).First(groupInfo).Error; err != nil {
			panic(err)
		}
		owner := new(model2.User)
		if err := mysql.ProdReadOnlyDB.Model(model2.User{}).Where("id = ?", groupInfo.Owner).First(owner).Error; err != nil {
			panic(err)
		}
		if owner.Code != owner.OriginCode && owner.Code != groupInfo.Code {
			updates = append(updates, UpdateGroupCode{
				GroupId: groupInfo.ImGroupId,
				OldCode: groupInfo.Code,
				NewCode: owner.Code,
			})
		}
	}
	for _, update := range updates {
		sql := fmt.Sprintf("UPDATE group_info SET code = '%s' WHERE im_group_id = '%s' AND code = '%s' limit 1", update.NewCode, update.GroupId, update.OldCode)
		fmt.Println(sql)
	}
	time.Sleep(time.Second)
}
