package main

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/script/mysql"
)

type RpcLog struct {
	Type int
	Msg  string
}

type Msg struct {
	GameType int `json:"gameType"`
}

var GameTypeMap = map[int]string{
	0: "slot",
	5: "幸运盒子",
	6: "水果机",
}

func main() {
	var rpcLogs []RpcLog
	if err := mysql.ProdReadOnlyDB.Table("rpc_log_202303 ").Where("`type` = 146").
		Where("created_time >= ? and created_time < ?", "2023-03-09", "2023-03-13").Find(&rpcLogs).Error; err != nil {
		panic(err)
	}
	var data = make(map[int]int)
	for _, log := range rpcLogs {
		msg := new(Msg)
		if err := json.Unmarshal([]byte(log.Msg), msg); err != nil {
			panic(err)
		}
		data[msg.GameType]++
	}
	for gameType, count := range data {
		println(GameTypeMap[gameType], count)
	}
}
