package utils

import "time"

const DEFAULT_LANG = "en"
const DATETIME_FORMAT = "2006-01-02 15:04:05"
const COMPACT_DATE_FORMAT = "20060102"
const DATE_FORMAT = "2006-01-02"

func GetZeroTime(t time.Time) time.Time {
	return time.Date(t.Year(), t.Month(), t.Day(), 0, 0, 0, 0, t.Location())
}

// 取最近的一个星期n
func GetLastDayOfWeek(t time.Time, n time.Weekday) time.Time {
	weekDay := t.Weekday()
	// 校正日期
	if weekDay < n {
		weekDay = 7 - n + weekDay
	} else {
		weekDay = weekDay - n
	}
	return t.AddDate(0, 0, -(int(weekDay)))
}
