package medal_tx

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/internal/model/user_m"
	"git.hilo.cn/hilo-common/resource/mysql"
	"time"
)

func SendMedal(model *domain.Model, userId, medalId mysql.ID, day int) error {
	endTime := time.Now().AddDate(0, 0, day)
	um := user_m.UserMedal{
		UserId:  userId,
		MedalId: uint32(medalId),
		EndTime: &endTime,
	}
	if err := um.Create(model.Db, day); err != nil {
		return err
	}
	return nil
}
