package headwear_tx

import (
	"errors"
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/internal/enum/headwear_e"
	"git.hilo.cn/hilo-common/internal/enum/msg_e"
	"git.hilo.cn/hilo-common/internal/model/msg_m"
	"git.hilo.cn/hilo-common/internal/model/res_m"
	"git.hilo.cn/hilo-common/internal/model/user_m"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/utils"
	"strconv"
	"time"
)

// 下发头饰
func SendHeadwear(model *domain.Model, receiverUserId mysql.ID, headdressId mysql.ID, days int) error {
	// 头饰增加
	receiveHeadwearDuration := uint32(days) * 3600 * 24
	if headdressId <= 0 {
		return errors.New("headdressId is 0")
	}
	userHeadwear, err := user_m.GetUserHeadwearOrInit(model, receiverUserId, headdressId)
	if err != nil {
		return err
	}
	nowTime := time.Now()
	if userHeadwear.EndTime.After(nowTime) {
		nowTime = userHeadwear.EndTime
	}
	userHeadwear.EndTime = nowTime.Add(time.Duration(receiveHeadwearDuration) * time.Second)
	maxEndTime, _ := time.ParseInLocation(utils.DATETIME_FORMAT, "2038-01-01 23:59:59", time.Local)
	if userHeadwear.EndTime.After(maxEndTime) {
		userHeadwear.EndTime = maxEndTime
	}
	if err := userHeadwear.Persistent(); err != nil {
		return err
	}
	//日志错误，并不事务回调
	if _, err = AddUserHeadwearLog(model, receiverUserId, headdressId, headwear_e.ActivityTrigger, headwear_e.AddSecond, &receiveHeadwearDuration, nil, 0); err != nil {
		model.Log.Error(err)
	}
	// 配套小助手
	go func() {
		model := domain.CreateModelContext(model.MyContext)
		resHeadwear := res_m.ResHeadwear{}
		if err := model.Db.Model(&res_m.ResHeadwear{}).First(&resHeadwear, headdressId).Error; err != nil {
			model.Log.Errorf("SendHeadwear get ResHeadwear fail:%v", err)
			return
		}
		user, err := user_m.GetUser(model, receiverUserId)
		if err != nil {
			model.Log.Errorf("SendHeadwear GetUser fail:%v", err)
			return
		}
		if err := msg_m.NewUserRecord(model, receiverUserId, msg_e.AddProps, user.Nick, user.ID, "", strconv.Itoa(int(days)), resHeadwear.PicUrl, "", "").Persistent(); err != nil {
			model.Log.Errorf("SendHeadwear NewUserRecord fail:%v", err)
			return
		}
		//推送msg
		_ = msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType)
	}()
	return err
}

//增加修改日志
func AddUserHeadwearLog(model *domain.Model, userId mysql.ID, headwearId mysql.ID, originType headwear_e.UserHeadwearLogOrginType, t headwear_e.UserHeadwearLogType, addSecond *uint32, UpdateEndTime *time.Time, operateUserId mysql.ID) (mysql.ID, error) {
	userHeadwearLog := user_m.UserHeadwearLog{
		UserId:        userId,
		OperateUserId: operateUserId,
		HeadwearId:    headwearId,
		OriginType:    originType,
		Type:          t,
		AddSecond:     addSecond,
		UpdateEndTime: UpdateEndTime,
	}
	if err := model.Db.Create(&userHeadwearLog).Error; err != nil {
		return 0, err
	}
	return userHeadwearLog.ID, nil
}

//删除头饰
func DelHeadwear(model *domain.Model, userId, headwearId mysql.ID) error {
	userHeadwear, err := user_m.GetUserHeadwearOrInit(model, userId, headwearId)
	if err != nil {
		return err
	}
	if userHeadwear, _, err = userHeadwear.MgrDel(0); err != nil {
		return err
	}
	return userHeadwear.Persistent()
}
