package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
)

type GroupBanned struct {
	mysql.Entity
	ImGroupId string
	MgrId     uint64
	RuleId    uint64
}

func (banned *GroupBanned) Set(model *domain.Model) error {
	return model.Db.Where(banned).Create(banned).Error
}

func (banned *GroupBanned) Get(model *domain.Model) error {
	return model.Db.Where(banned).First(banned).Error
}

func (banned *GroupBanned) Delete(model *domain.Model) error {
	return model.Db.Where(banned).Delete(&GroupBanned{}).Error
}

func GetBannedGroups(model *domain.Model) ([]GroupBanned, error) {
	result := make([]GroupBanned, 0)
	err := model.Db.Find(&result).Error
	if err != nil {
		return nil, err
	}
	return result, nil
}

func GetBannedGroupsMap(model *domain.Model) (map[string]uint64, error) {
	r, err := GetBannedGroups(model)
	if err != nil {
		return nil, err
	}
	result := make(map[string]uint64, 0)
	for _, i := range r {
		result[i.ImGroupId] = i.MgrId
	}
	return result, nil
}
