package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"gorm.io/gorm"
	"hilo-group/myerr"
	"hilo-group/myerr/bizerr"
	"time"
)

type GroupInviteJoin struct {
	Id           uint64    `json:"id"`
	UserId       uint64    `json:"user_id"`
	ImGroupId    string    `json:"im_group_id"`
	CreatedTime  time.Time `json:"created_time"`
	UpdatedTime  time.Time `json:"updated_time"`
	InviteUserId uint64    `json:"invite_user_id"`
	IsAccept     int8      `json:"is_accept"`
}

func GetByImGroupId(model *domain.Model, imGroupId string) (*GroupInfo, error) {
	if len(imGroupId) <= 0 {
		return nil, myerr.WrapErr(bizerr.GroupNotFound)
	}

	res := new(GroupInfo)
	err := model.DB().Where(&GroupInfo{ImGroupId: imGroupId}).First(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return res, nil
}

func AcceptGroupInviteJoin(model *domain.Model, userId uint64, imGroupId string) error {
	err := model.DB().Exec("update group_invite_join set is_accept = 1 where user_id=? and im_group_id=?", userId, imGroupId).Error
	if err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

func GetGroupInviteJoin(model *domain.Model, userId uint64, imGroupId string) (*GroupInviteJoin, error) {
	res := new(GroupInviteJoin)
	err := model.DB().Where(&GroupInviteJoin{UserId: userId, ImGroupId: imGroupId}).Where("is_accept=0").First(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return res, nil
}

func InsertGroupInviteJoin(model *domain.Model, userId, inviteUserId uint64, imGroupId string) error {
	nowTime := time.Now()
	sql := "insert into group_invite_join(user_id,invite_user_id,im_group_id,is_accept,created_time,updated_time) " +
		"value(?,?,?,?,?,?) on duplicate key update is_accept=?,created_time=?,updated_time=?"
	err := model.DB().Exec(sql, userId, inviteUserId, imGroupId, 0, nowTime, nowTime, 0, nowTime, nowTime).Error
	if err != nil {
		return myerr.WrapErr(bizerr.GroupNotFound)
	}
	return nil
}
