package group_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/group_e"
	"time"
)

type GroupSupporter struct {
	mysql.Entity
	GroupId string
	UserId  uint64
}

func (gs *GroupSupporter) Get(db *gorm.DB) ([]uint64, error) {
	rows := make([]GroupSupporter, 0)
	err := db.Model(&GroupSupporter{}).Where(gs).Find(&rows).Error
	if err != nil {
		return nil, err
	}
	result := make([]uint64, 0)
	for _, i := range rows {
		result = append(result, i.UserId)
	}
	return result, nil
}

// 根据时间返回支持鼓励的放送周期
func GetLastSupportPeriod(t time.Time) (time.Time, time.Time, string) {
	t = t.AddDate(0,0,-group_e.SUPPORT_LEVEL_PERIOD_DAY)
	return GetSupportLevelTime(t)
}

func (gs *GroupSupporter) Delete(db *gorm.DB) error {
	return db.Where(gs).Delete(&GroupSupporter{}).Error
}

func (gs *GroupSupporter) BatchSave(db *gorm.DB, userIds []uint64) error {
	records := make([]GroupSupporter, 0)
	for _, i := range userIds {
		records = append(records, GroupSupporter{
			GroupId: gs.GroupId,
			UserId:  i,
		})
	}
	return db.Create(&records).Error
}
