package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/match_e"
	"hilo-group/myerr"
)

/**
 * 用户财富分数
 **/
type MatchWealthUserScore struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Score         mysql.Num
	Grade         mysql.Num
}

/**
 * 获取的分数同等级关系
 **/
type MatchWealthSetScoreGrade struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	MinNum        mysql.Num
	MaxNum        mysql.Num
	Grade         mysql.Num
}

type MatchWealthUserScoreDetail struct {
	mysql.Entity
	MatchWealthUserScoreId mysql.ID
	UserId                 mysql.ID
	BeforeScore            mysql.Num
	Score                  mysql.Num
	AfterScore             mysql.Num
	Type                   match_e.MatchWealthUserScoreDetailType
	OrginId                mysql.ID
}

func addMatchWealthUserScoreDetail(model *domain.Model, matchWealthUserScoreId mysql.ID, userId mysql.ID, beforeScore mysql.Num, score mysql.Num, t match_e.MatchWealthUserScoreDetailType, orginId mysql.ID) error {
	if err := model.Db.Save(&MatchWealthUserScoreDetail{
		MatchWealthUserScoreId: matchWealthUserScoreId,
		UserId:                 userId,
		BeforeScore:            beforeScore,
		Score:                  score,
		AfterScore:             beforeScore + score,
		Type:                   t,
		OrginId:                orginId,
	}).Error; err != nil {
		return myerr.WrapErr(err)
	}
	return nil
}

//获取财富等级
func GetWealthGrade(model *domain.Model, userId mysql.ID) (uint32, uint32, error) {
	var wealthUserScore MatchWealthUserScore
	if err := model.Db.Model(&MatchWealthUserScore{}).Where(&MatchWealthUserScore{UserId: userId}).First(&wealthUserScore).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return 0, 0, nil
		} else {
			return 0, 0, myerr.WrapErr(err)
		}
	}
	return wealthUserScore.Grade, wealthUserScore.Score, nil
}

func getMatchWealthUserScore(model *domain.Model, userId mysql.ID) (*MatchWealthUserScore, error) {
	var matchWealthUserScore MatchWealthUserScore
	if err := model.Db.Where(&MatchWealthUserScore{
		UserId: userId,
	}).First(&matchWealthUserScore).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			matchWealthUserScore = MatchWealthUserScore{
				UserId: userId,
				Score:  0,
				Grade:  0,
			}
		} else {
			return nil, err
		}
	}
	matchWealthUserScore.Model = model
	return &matchWealthUserScore, nil
}

/**
 * 增加分数
 **/
func (matchWealthUserScore *MatchWealthUserScore) updateScore(diamondNum mysql.Num) error {
	//接受高并发容错
	matchWealthUserScore.Score = diamondNum
	//对应其等级
	var matchWealthSetScoreGrade MatchWealthSetScoreGrade
	if err := matchWealthUserScore.Db.Where("min_num <= ? AND max_num >= ?", matchWealthUserScore.Score, matchWealthUserScore.Score).First(&matchWealthSetScoreGrade).Error; err != nil {
		return myerr.WrapErr(err)
	}
	matchWealthUserScore.Grade = matchWealthSetScoreGrade.Grade
	return nil
}
