package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/myerr"
)

type UserOauth struct {
	UserId         uint64 `json:"user_id"`
	ThirdPartyId   string `json:"third_party_id"`
	ThirdPartyType int8   `json:"third_party_type"`
}

func (p *UserOauth) TableName() string {
	return "user_oauth"
}

func GetUserOauthByUserId(model *domain.Model, userId uint64, thirdType uint8) ([]*UserOauth, error) {
	res := make([]*UserOauth, 0)
	db := mysql.Db.Where(&UserOauth{UserId: userId})
	if thirdType > 0 {
		db = db.Where(&UserOauth{ThirdPartyType: int8(thirdType)})
	}
	err := db.Find(&res).Error
	if err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return res, nil
}
