package gift_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"github.com/robfig/cron"
	"hilo-group/domain/model/event_m"
)

// 补偿检查mark=2
func GiftRemark() {
	c := cron.New()
	// 每5分钟
	spec := "0 */5 * * * ?"
	if !config.AppIsRelease() {
		spec = "0 * * * * ?" // 测服1分钟
	}
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		unmarks, err := event_m.FetchUnMarkEvents(model, 10)
		if err != nil {
			model.Log.Errorf("FetchUnMarkEvents fail:%v", err)
			return
		}
		for _, unmark := range unmarks {
			model.Log.Infof("FetchUnMarkEvent start:%v", unmark.ID)
			// 重新入库
			if err := event_m.AddUnMarkEvent(model, &event_m.EventGiftSend{
				Proto:         unmark.Proto,
				Payload:       unmark.Payload,
				MarkHiloGroup: unmark.MarkHiloGroup,
				Mark:          unmark.Mark, // 不能影响别的服务的mark状态
			}); err != nil {
				model.Log.Errorf("FetchUnMarkEvent add unmark fail:%v", err)
				continue
			}
			// 旧的标记已处理
			unmark.Model = model
			if err := unmark.MarkDone(); err != nil {
				model.Log.Errorf("FetchUnMarkEvent mark fail:%v", err)
			}
			model.Log.Infof("FetchUnMarkEvent success:%v", unmark.ID)
		}
	})
	c.Start()
}
