package msg_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"git.hilo.cn/hilo-common/sdk/emas"
	"git.hilo.cn/hilo-common/utils"
	"hilo-group/_const/enum/msg_e"
)

type MsgUserRecord struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	UserId        mysql.ID
	Type          msg_e.MsgUserRecordType
	Nick          mysql.Str
	NickUserId    mysql.ID //用户的别名
	DiamondIncome mysql.Str
	DayNum        mysql.Str //多少天
	PropertyUrl   mysql.Str //道具地址
	BeanNum       mysql.Str //多少豆子
	GroupCode     mysql.Str //群组code
}

type MsgReceive struct {
	Type msg_e.MsgReceiveType `json:"type"`
}

func NewUserRecord(model *domain.Model, userId mysql.ID, t msg_e.MsgUserRecordType, nick mysql.Str, nickUserId mysql.ID, diamondIncome mysql.Str, dayNum mysql.Str, propertyUrl mysql.Str, beanNum mysql.Str, groupCode mysql.Str) *MsgUserRecord {
	return &MsgUserRecord{
		Model:         model,
		UserId:        userId,
		Type:          t,
		Nick:          nick,
		NickUserId:    nickUserId,
		DiamondIncome: diamondIncome,
		DayNum:        dayNum,
		PropertyUrl:   propertyUrl,
		BeanNum:       beanNum,
		GroupCode:     groupCode,
	}
}

//发给小助手的消息, 不需要抛出错误
func SendEmasMsgAssistant(model *domain.Model, externalId string, deviceType string) error {
	str, _ := utils.ToString(MsgReceive{
		Type: msg_e.UserMsgReceiveType,
	})
	err := emas.SendMsg(externalId, deviceType, str)
	if err != nil {
		model.Log.Errorf("emas.SendMsg err:%v", err)
	}
	return nil
}
