package noble_cv

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/domain/model/noble_m"
	"hilo-group/myerr"
	"time"
)

type NobleConfig struct {
	Level         uint16 `json:"level"`         // 贵族等级
	PurchasePrice uint32 `json:"purchasePrice"` // 购买价格
	RenewalPrice  uint32 `json:"renewalPrice"`  // 续费价格
	Duration      uint16 `json:"duration"`      // 有效期（天）
	PicUrl        string `json:"picUrl"`        // 大图url
	DailyGold     uint   `json:"dailyGold"`     // 每日登录领取的金币
	RideId        uint64 `json:"rideId"`        // 赠送的勋章ID
	HeaddressId   uint64 `json:"headdressId"`   // 赠送的头饰ID
	Privileges    []int  `json:"privileges"`    // 权益列表
}

type NobleInfo struct {
	Level      uint16 `json:"level"`      // 等级
	EndTime    int64  `json:"endTime"`    // 截止时间
	RemainTime int64  `json:"remainTime"` // 还有多久（秒）过期，可以是负数
	Price      uint32 `json:"price"`      // 购买或续费价格
}

type CvNoble struct {
	Level   uint16 `json:"level"`
	EndTime int64  `json:"endTime"`
}

func GetCvNoble(userId uint64) (CvNoble, error) {
	userNoble := noble_m.UserNoble{}
	if err := mysql.Db.Model(&noble_m.UserNoble{}).Where(&noble_m.UserNoble{
		UserId: userId,
	}).Where("end_time > ?", time.Now()).Order("level desc").First(&userNoble).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return CvNoble{
				Level:   0,
				EndTime: 0,
			}, nil
		} else {
			return CvNoble{
				Level:   0,
				EndTime: 0,
			}, myerr.WrapErr(err)
		}
	} else {
		return CvNoble{
			Level:   userNoble.Level,
			EndTime: userNoble.EndTime.Unix(),
		}, nil
	}
}

func GetCvNobles(userIds []uint64) (map[uint64]CvNoble, error) {
	if len(userIds) == 0 {
		return map[uint64]CvNoble{}, nil
	}
	userNobles := []noble_m.UserNoble{}
	if err := mysql.Db.Model(&noble_m.UserNoble{}).Where("user_id in (?)", userIds).Where("end_time > ?", time.Now()).Order("level asc").Find(&userNobles).Error; err != nil {
		return nil, err
	}

	userNobleMap := map[uint64]noble_m.UserNoble{}
	for i, _ := range userNobles {
		userNobleMap[userNobles[i].UserId] = userNobles[i]
	}

	result := map[uint64]CvNoble{}
	for _, r := range userIds {
		userNoble, flag := userNobleMap[r]
		if flag {
			result[r] = CvNoble{
				Level:   userNoble.Level,
				EndTime: userNoble.EndTime.Unix(),
			}
		} else {
			result[r] = CvNoble{
				Level:   0,
				EndTime: 0,
			}
		}
	}
	return result, nil
}
