package group_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"github.com/robfig/cron"
	"hilo-group/domain/event/group_power_ev"
	"hilo-group/domain/model/groupPower_m"
)

// 清理家族经验和等级
func GroupPowerExpClear() {
	c := cron.New()
	// 每月1号0:00经验值清零
	spec := "0 0 0 1 * ?"
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		if err := groupPower_m.ClearGroupPowerExp(model); err != nil {
			model.Log.Errorf("ClearGroupPowerExp fail:%v", err)
		}
	})

	// 每分钟清理过期家族等级
	spec = "0 * * * * ?"
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		if err := groupPower_m.ClearGroupPowerGrade(model); err != nil {
			model.Log.Errorf("ClearGroupPowerGrade fail:%v", err)
		}
	})
	// 每月20号发家族即将过期通知
	spec = "0 0 0 20 * ?"
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		_ = group_power_ev.PublishGroupPowerExpireNotice(model, &group_power_ev.GroupPowerExpireNoticeEvent{})
	})
	c.Start()
}
