package group_cron

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"github.com/robfig/cron"
	"hilo-group/_const/enum/group_e"
	"hilo-group/domain/service/group_s"
)

func CreateGroup() {
	if !config.IsMaster() {
		return
	}
	c := cron.New()
	spec := "0 15 15 16 8 ?"
	_ = c.AddFunc(spec, func() {
		var model = domain.CreateModelNil()
		userId := uint64(7687)
		num := 20
		if config.AppIsRelease() {
			userId = 8350311
			num = 1000
		}
		err := group_s.NewGroupService(model.MyContext).CreateGroupMulByUid(userId, num, group_e.TwoMicNumType)
		if err != nil {
			model.Log.Errorf("CreateGroupMulByUid fail:%v", err)
		}
	})

	c.Start()
}
