-CREATE TABLE `group_trtc` (
                               `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                               `im_group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
                               `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                               `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                               PRIMARY KEY (`id`),
                               UNIQUE KEY `im_group_id` (`im_group_id`),
                               KEY `created_time` (`created_time`) USING BTREE
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='使用trtc的群组';

CREATE TABLE `group_im` (
                            `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                            `provider` int NOT NULL COMMENT '厂商类型0.声网1.腾讯trtc',
                            `prob` bigint unsigned NOT NULL COMMENT '概率',
                            `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                            `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                            PRIMARY KEY (`id`),
                            KEY `created_time` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='房间im厂商选用概率配置';

INSERT INTO hilo.group_im (`provider`, `prob`)
VALUES (0, 1000),
       (1, 1000);

CREATE TABLE `group_im_log` (
                                `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                                `im_group_id` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
                                `provider` int NOT NULL COMMENT '厂商类型0.声网1.腾讯trtc',
                                `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                PRIMARY KEY (`id`),
                                KEY `im_group_id_idx` (`im_group_id`) USING BTREE,
                                KEY `created_time_idx` (`created_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='房间im提供商切换log';