package group_m

import (
	"git.hilo.cn/hilo-common/domain"
	"hilo-group/myerr/bizerr"
)

func ToTxGroupId(model *domain.Model, imGroupId string) (string, error) {
	if len(imGroupId) <= 0 {
		return "", nil
	}

	gi, err := GetGroupInfo(model, imGroupId)
	if err != nil {
		return "", err
	}
	if gi == nil {
		return "", bizerr.GroupNotFound
	}
	return gi.TxGroupId, nil
}

func ToImGroupId(model *domain.Model, txGroupId string) (string, error) {
	if len(txGroupId) <= 0 {
		return "", nil
	}

	gi, err := GetInfoByTxGroupId(model, txGroupId)
	if err != nil {
		return "", err
	}
	if gi == nil {
		return "", bizerr.GroupNotFound
	}
	return gi.ImGroupId, nil
}
