package mgr_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
)

type MgrOperationModuleUrl struct {
	mysql.Entity
	ModuleId mysql.ID
	Method   string
	FullPath string
}

type MgrOperationLog struct {
	mysql.Entity
	ModuleId    mysql.ID
	ModuleUrlId mysql.ID
	Content     string
	Description string
	MediaUrls   string
	TargetUid   mysql.ID
	OperUid     mysql.ID
	MgrId       mysql.ID
}

// 根据path获取操作模块
func GetOperationModuleUrl(model *domain.Model, method, fullPath string) MgrOperationModuleUrl {
	var config MgrOperationModuleUrl
	if err := model.Db.Model(MgrOperationModuleUrl{}).Where("method = ? AND full_path = ?", method, fullPath).First(&config).Error; err != nil {
		if err != gorm.ErrRecordNotFound {
			model.Log.Errorf("GetOperationModuleUrl fail:%v", err)
		}
	}
	return config
}

// 保存操作日志
func SaveOperationLog(model *domain.Model, log MgrOperationLog) error {
	err := model.Db.Create(&log).Error
	return err
}
