ALTER TABLE hilo.group_power ADD nameplate varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' NOT NULL COMMENT '家族铭牌';
ALTER TABLE hilo.group_power ADD declaration varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' NOT NULL COMMENT '家族宣言';
ALTER TABLE hilo.group_power ADD icon varchar(200) DEFAULT 'https://image.whoisamy.shop/hilo/resource/family_default.png' NOT NULL COMMENT '家族头像';
CREATE INDEX nameplate_IDX USING BTREE ON hilo.group_power (nameplate);

CREATE TABLE `group_power_invite_join` (
                                           `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                                           `user_id` bigint unsigned NOT NULL COMMENT '被邀请者id',
                                           `group_power_id` bigint unsigned NOT NULL,
                                           `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                           `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                           `invite_user_id` bigint unsigned NOT NULL COMMENT '邀请者id',
                                           `is_accept` tinyint NOT NULL DEFAULT '0' COMMENT '是否已经接受邀请',
                                           PRIMARY KEY (`id`),
                                           UNIQUE KEY `user_group` (`user_id`,`group_power_id`),
                                           KEY `group_power_id` (`group_power_id`),
                                           KEY `invite_user_id` (`invite_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='邀请加入家族';

CREATE TABLE `group_power_apply_join` (
                                          `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                                          `user_id` bigint unsigned NOT NULL COMMENT '申请者id',
                                          `group_power_id` bigint unsigned NOT NULL,
                                          `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                          `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                          `is_accept` tinyint NOT NULL DEFAULT '0' COMMENT '是否已经接受',
                                          `mgr_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT '审核的管理员id',
                                          PRIMARY KEY (`id`),
                                          KEY `group_power_id` (`group_power_id`),
                                          KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='申请加入家族';

CREATE TABLE `group_power_quit_log` (
                                        `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
                                        `user_id` bigint unsigned NOT NULL COMMENT '用户id',
                                        `mgr_id` bigint unsigned NOT NULL COMMENT '操作人id',
                                        `created_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                        `updated_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                                        `group_power_id` bigint unsigned NOT NULL,
                                        PRIMARY KEY (`id`),
                                        KEY `user_id` (`user_id`) USING BTREE,
                                        KEY `created_time` (`created_time`) USING BTREE,
                                        KEY `mgr_id` (`mgr_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;