package group_power_s

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/domain/event/group_power_ev"
	"hilo-group/domain/model/groupPower_m"
)

type GroupPowerService struct {
	svc *domain.Service
}

func NewGroupPowerService(myContext *mycontext.MyContext) *GroupPowerService {
	svc := domain.CreateService(myContext)
	return &GroupPowerService{svc}
}

//用户加入国家势力
func (s *GroupPowerService) GroupPowerUserJoin(groupPowerId mysql.ID, userId mysql.ID) error {
	return s.svc.Transactional(func() error {
		model := domain.CreateModelContext(s.svc.MyContext)
		groupPower, err := groupPower_m.GetGroupPower(model, groupPowerId)
		if err != nil {
			return err
		}
		groupPowerUser, err := groupPower.UserJoin(userId)
		if err != nil {
			return err
		}
		if err := groupPowerUser.Persistent(); err != nil {
			return err
		}
		return group_power_ev.PublishGroupPowerJoin(model, &group_power_ev.GroupPowerJoinEvent{
			UserId:       userId,
			GroupPowerId: groupPowerId,
		})
	})
}

//用户退出国家势力
func (s *GroupPowerService) GroupPowerUserLeave(groupPowerId mysql.ID, userId mysql.ID) (int, error) {
	remainSeconds := 0
	err := s.svc.Transactional(func() error {
		model := domain.CreateModelContext(s.svc.MyContext)
		groupPower, err := groupPower_m.GetGroupPower(model, groupPowerId)
		if err != nil {
			return err
		}
		groupPowerUser, timeDiff, err := groupPower.UserLeave(userId)
		if err != nil {
			if timeDiff > 0 {
				remainSeconds = int(timeDiff.Seconds())
				return err
			}
			return err
		}
		if err := groupPowerUser.Persistent(); err != nil {
			return err
		}
		return group_power_ev.PublishGroupPowerLeave(model, &group_power_ev.GroupPowerLeaveEvent{
			UserId:       userId,
			GroupPowerId: groupPowerId,
		})
	})
	return remainSeconds, err
}
