package group_k

import (
	"fmt"
	"hilo-group/_const/redis_key"
)

// 用户进房的key
const (
	UserEnterRoomPrefix   = "uer:"
	UserEnterRoomUserKey  = UserEnterRoomPrefix + "u:${user_id}"
	UserEnterRoomGroupKey = UserEnterRoomPrefix + "g:${user_id}"
)

func GetUserEnterRoomUserKey(userId uint64) string {
	return redis_key.ReplaceKey(UserEnterRoomUserKey, fmt.Sprintf("%d", userId))
}

func GetUserEnterRoomGroupKey(groupId string) string {
	return redis_key.ReplaceKey(UserEnterRoomGroupKey, groupId)
}
