package group_k

import (
	"fmt"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/_const/redis_key"
)

const (
	GroupPrefix         = "group:"
	GroupLock           = GroupPrefix + "lock:${user_id}"
	GroupSupportAwardIp = GroupPrefix + "support:award:ip:${ip}" // string, ttl=7天-n ip领取扶持次数
	EditGroupCd         = "edit:group:cd:${imGroupId}"
	GroupInfo           = "group:info:%s"
)

// 创建群组并发锁
func GetGroupLockKey(userId mysql.ID) string {
	return redis_key.ReplaceKey(GroupLock, fmt.Sprintf("%d", userId))
}

// ip领取扶持次数
func GetGroupSupportAwardIpKey(ip mysql.Str) string {
	return redis_key.ReplaceKey(GroupSupportAwardIp, ip)
}

// 编辑群组资料cd
func GetEditGroupCDKey(imGroupId mysql.Str) string {
	return redis_key.ReplaceKey(EditGroupCd, imGroupId)
}

//
func GetGroupInfoKey(imGroupId mysql.Str) string {
	return fmt.Sprintf(GroupInfo, imGroupId)
}
