package group_cv

import (
	"hilo-group/domain/model/group_m"
	"time"
)

//麦位信息，
type CvMic struct {
	//麦位
	I int `json:"i"`
	//锁，是否有锁 true:锁了， false:没锁
	Lock bool `json:"lock"`
	//静音 true:静音，false:没有静音
	Forbid bool `json:"forbid"`
	//如果 nil 则代表这个位置上没有人
	ExternalId *string `json:"externalId"`
	//声网agoraId 如果 nil 则代表这个位置上没有人
	AgoraId *uint32 `json:"agoraId"`
	//上麦时间戳
	Timestamp int64 `json:"timestamp"`
}

//获取群组中所有的mic位信息
func GetGroupMicAll(mics []group_m.Mic, micUsers []group_m.MicUser) ([]CvMic, error) {
	timestamp := time.Now().Unix()
	micUserMap := map[int]*group_m.MicUser{}
	for i := 0; i < len(micUsers); i++ {
		micUserMap[micUsers[i].I] = &(micUsers[i])
	}
	//
	var cvMics []CvMic
	for _, v := range mics {
		forbid := false
		var externalId *string = nil
		var agoraId *uint32 = nil
		if u, ok := micUserMap[v.I]; ok {
			forbid = u.Forbid
			externalId = &u.ExternalId
			tmp := uint32(u.UserId)
			agoraId = &tmp
		}
		cvMics = append(cvMics, CvMic{
			I:          v.I,
			Lock:       v.Lock,
			Forbid:     forbid,
			ExternalId: externalId,
			AgoraId:    agoraId,
			Timestamp:  timestamp,
		})
	}
	return cvMics, nil
}
