package group_power_r

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/gin-gonic/gin"
	"hilo-group/_const/enum/groupPower_e"
	"hilo-group/_const/enum/msg_e"
	"hilo-group/cv/group_power_cv"
	"hilo-group/domain/model/groupPower_m"
	"hilo-group/domain/model/msg_m"
	"hilo-group/domain/model/user_m"
	"hilo-group/resp"
)

type MGetGroupPowerReq struct {
	Ids []mysql.ID `form:"ids" binding:"required"`
}

// @Tags 国家势力-内部
// @Summary 批量获取国家势力信息
// @Param ids query string true "用户id,如:ids=1&ids=2&ids=3"
// @Success 200 {object} map[mysql.ID]group_power_cv.CvGroupPowerInfo
// @Router /inner/groupPower/infos [get]
func MGetGroupPowers(c *gin.Context) (*mycontext.MyContext, error) {
	myCtx := mycontext.CreateMyContext(c.Keys)
	var model = domain.CreateModelContext(myCtx)
	var req MGetGroupPowerReq
	if err := c.ShouldBindQuery(&req); err != nil {
		return myCtx, err
	}
	groupPowers, err := groupPower_m.MGetGroupPowerInfoMap(model, req.Ids)
	if err != nil {
		return myCtx, err
	}
	groupPowerUsers, err := groupPower_m.MGetGroupPowerUsers(model, req.Ids)
	if err != nil {
		return myCtx, err
	}
	groupPowerGrade, err := groupPower_m.MGetGroupPowerGrade(model, req.Ids)
	if err != nil {
		return myCtx, err
	}
	response := make(map[mysql.ID]group_power_cv.CvGroupPowerInfo)
	for groupPowerId, info := range groupPowers {
		// 成员上限
		var memberMax mysql.Num
		grade := groupPowerGrade[groupPowerId].Grade
		if grade >= groupPower_e.GroupPowerGrade0 && grade <= groupPower_e.GroupPowerGradeMax {
			memberMax = mysql.Num(group_power_cv.GroupPowerGradePrivilegeNum[groupPowerGrade[groupPowerId].Grade][0].Num)
		}
		memberNum := mysql.Num(len(groupPowerUsers[groupPowerId]))
		if memberNum > memberMax {
			memberMax = memberNum
		}
		response[groupPowerId] = group_power_cv.CvGroupPowerInfo{
			CvGroupPowerBase: group_power_cv.CvGroupPowerBase{
				Id:        groupPowerId,
				Icon:      info.Icon,
				Name:      info.Name,
				Nameplate: info.Nameplate,
			},
			CvGroupPowerMember: group_power_cv.CvGroupPowerMember{
				MemberNum: memberNum,
				MemberMax: memberMax,
			},
			CvGroupPowerGrade: group_power_cv.CvGroupPowerGrade{
				Grade: grade,
				Exp:   groupPowerGrade[groupPowerId].Exp,
			},
		}
	}
	resp.ResponseOk(c, response)
	return myCtx, nil
}

func Test(c *gin.Context) (*mycontext.MyContext, error) {
	var model = domain.CreateModelNil()
	if err := msg_m.NewUserRecord(model, 4549, msg_e.GroupPowerExpireNotice, "", 4549, "", "", "", "", "").Persistent(); err != nil {
		return nil, err
	}
	mgrUser, _ := user_m.GetUser(model, 4549)
	err := msg_m.SendEmasMsgAssistant(model, mgrUser.ExternalId, mgrUser.DeviceType)
	if err != nil {
		return nil, err
	}
	//err := emas.SendIosMsgAll("全部消息测试")
	//if err != nil {
	//	return nil, err
	//}
	return nil, nil
}
