package event_s

import (
	"git.hilo.cn/hilo-common/domain"
	"hilo-group/_const/enum/msg_e"
	"hilo-group/domain/event/group_ev"
	"hilo-group/domain/event/group_power_ev"
	"hilo-group/domain/model/diamond_m"
	"hilo-group/domain/model/groupPower_m"
	"hilo-group/domain/model/msg_m"
	"hilo-group/domain/model/user_m"
	"strconv"
)

func EventInit() {
	GroupPowerEvents()
	GroupSupportEvents()
}

func GroupSupportEvents() {
	//群组支持
	group_ev.AddGroupSupportSync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupSupportEvent)
		if !ok {
			model.Log.Errorf("AddGroupSupportSync fail data")
			return nil
		}
		model.Log.Infof("diamond AddGroupSupport admin:%v mgrs:%v", event.GroupSupportAwardAdmin, event.GroupSupportAwardMgrs)
		diamondAccountAdmin, err := diamond_m.GetDiamondAccountByUserId(model, event.GroupSupportAwardAdmin.UserId)
		if err != nil {
			return err
		}
		diamondAccountDetailAdmin, err := diamondAccountAdmin.GroupSupportAdmin(event.GroupSupportAwardAdmin.GroupSupportAwardId, event.GroupSupportAwardAdmin.DiamondNum)
		if err != nil {
			return err
		}
		if err := diamondAccountDetailAdmin.Persistent(); err != nil {
			return err
		}
		for i, _ := range event.GroupSupportAwardMgrs {
			diamondAccount, err := diamond_m.GetDiamondAccountByUserId(model, event.GroupSupportAwardMgrs[i].UserId)
			if err != nil {
				return err
			}
			diamondAccountDetail, err := diamondAccount.GroupSupportMgr(event.GroupSupportAwardMgrs[i].GroupSupportAwardId, event.GroupSupportAwardMgrs[i].DiamondNum)
			if err != nil {
				return err
			}
			if err := diamondAccountDetail.Persistent(); err != nil {
				return err
			}
		}
		return nil
	})

	//群组支持奖励
	group_ev.AddGroupSupportAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_ev.GroupSupportEvent)
		if !ok {
			model.Log.Errorf("AddGroupSupportSync fail data")
			return nil
		}
		model.Log.Infof("msg AddGroupSupportAsync admin:%v, mgr:%v", event.GroupSupportAwardAdmin, event.GroupSupportAwardMgrs)
		for i, _ := range event.GroupSupportAwardMgrs {
			user, err := user_m.GetUser(model, event.GroupSupportAwardMgrs[i].UserId)
			if err != nil {
				model.Log.Errorf("msg AddGroupSupportAsync GetUser userId:%v, err:%v", event.GroupSupportAwardMgrs[i].UserId, err)
			}
			if err := msg_m.NewUserRecord(model, user.ID, msg_e.GroupSupport, user.Nick, user.ID, strconv.FormatUint(uint64(event.GroupSupportAwardMgrs[i].DiamondNum), 10), "", "", "", event.GroupCode).Persistent(); err != nil {
				model.Log.Errorf("msg AddGroupSupportAsync NewUserRecord err:%v", err)
				break
			}
			msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType)
		}
		user, err := user_m.GetUser(model, event.GroupSupportAwardAdmin.UserId)
		if err != nil {
			model.Log.Errorf("msg AddGroupSupportAsync GetUser userId:%v, err:%v", event.GroupSupportAwardAdmin.UserId, err)
		}
		if err := msg_m.NewUserRecord(model, user.ID, msg_e.GroupSupport, user.Nick, user.ID, strconv.FormatUint(uint64(event.GroupSupportAwardAdmin.DiamondNum), 10), "", "", "", event.GroupCode).Persistent(); err != nil {
			model.Log.Errorf("msg AddGroupSupportAsync NewUserRecord err:%v", err)
			return nil
		}
		msg_m.SendEmasMsgAssistant(model, user.ExternalId, user.DeviceType)
		return nil
	})

}

func GroupPowerEvents() {
	//加入势力
	group_power_ev.AddGroupPowerJoinAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_power_ev.GroupPowerJoinEvent)
		if !ok {
			model.Log.Errorf("AddGroupPowerJoinAsync event type err")
			return nil
		}
		model.Log.Infof("msg AddGroupPowerJoinAsync UserId:%v, GroupPowerId:%v", event.UserId, event.GroupPowerId)
		//获取势力主
		mgrUserId, err := groupPower_m.GetGroupPowerMgr(model, event.GroupPowerId)
		if err != nil {
			return err
		}
		mgrUser, err := user_m.GetUser(model, mgrUserId)
		if err != nil {
			return err
		}
		joinUser, err := user_m.GetUser(model, event.UserId)
		if err != nil {
			return err
		}
		if err := msg_m.NewUserRecord(model, mgrUser.ID, msg_e.GroupPowerUserJoin, joinUser.Nick, joinUser.ID, "", "", "", "", "").Persistent(); err != nil {
			model.Log.Errorf("msg AddGroupPowerJoinAsync NewUserRecord err:%v", err)
			return nil
		}
		msg_m.SendEmasMsgAssistant(model, mgrUser.ExternalId, mgrUser.DeviceType)
		return nil
	})
	//离开势力
	group_power_ev.AddGroupPowerLeaveAsync(func(model *domain.Model, e interface{}) error {
		event, ok := e.(*group_power_ev.GroupPowerLeaveEvent)
		if !ok {
			model.Log.Errorf("AddGroupPowerLeaveAsync event type err")
			return nil
		}
		model.Log.Infof("msg AddGroupPowerLeaveAsync UserId:%v, GroupPowerId:%v", event.UserId, event.GroupPowerId)
		//获取势力主
		mgrUserId, err := groupPower_m.GetGroupPowerMgr(model, event.GroupPowerId)
		if err != nil {
			return err
		}
		mgrUser, err := user_m.GetUser(model, mgrUserId)
		if err != nil {
			return err
		}
		joinUser, err := user_m.GetUser(model, event.UserId)
		if err != nil {
			return err
		}
		if err := msg_m.NewUserRecord(model, mgrUser.ID, msg_e.GroupPowerUserLeave, joinUser.Nick, joinUser.ID, "", "", "", "", "").Persistent(); err != nil {
			model.Log.Errorf("msg AddGroupPowerLeaveAsync NewUserRecord err:%v", err)
			return nil
		}
		msg_m.SendEmasMsgAssistant(model, mgrUser.ExternalId, mgrUser.DeviceType)
		return nil
	})
}
