package res_e

import "git.hilo.cn/hilo-common/resource/mysql"

type MsgIdType = uint

const (
	DEFAULT_LANG = "en"

	MSG_ID_GAME_CREATE MsgIdType = 1001
	MSG_ID_GAME_JOIN   MsgIdType = 1002
)

type ResMedalType = mysql.Type

const (
	Wealth        ResMedalType = 1
	Charm         ResMedalType = 2
	LoveForAll    ResMedalType = 3
	StartForAll   ResMedalType = 4
	MoonForAll    ResMedalType = 5
	MarryMe       ResMedalType = 6
	RoomRocket    ResMedalType = 7
	Actity        ResMedalType = 8
	FruitKing     ResMedalType = 9
	BoxKing       ResMedalType = 10
	Helicopter    ResMedalType = 11
	Roadster      ResMedalType = 12
	Watermelon    ResMedalType = 13
	Kiss          ResMedalType = 14
	Love          ResMedalType = 15
	Chick         ResMedalType = 16
	SportsCar     ResMedalType = 17
	Rocket        ResMedalType = 18
	Tower         ResMedalType = 19
	Eagle         ResMedalType = 20
	Lion          ResMedalType = 21
	Vacation      ResMedalType = 22
	RomanticNight ResMedalType = 23
	SweetCouple   ResMedalType = 24
	Castle        ResMedalType = 25
	WeddingCar    ResMedalType = 26
	VideoChat     ResMedalType = 27
)

type ResMedalScope = mysql.Type

const (
	//私有，只能时管理人发放
	Private ResMedalScope = 1
	//公有，自己获取
	Public ResMedalScope = 2
)

type ResPropertyAvatarType = mysql.Type

const (
	SendGiftCpPropertyAvatarType    ResPropertyAvatarType = 1 //周CP
	MonthlyWealthPropertyAvatarType ResPropertyAvatarType = 2 //月冠财富榜
	MonthlyCharmPropertyAvatarType  ResPropertyAvatarType = 3 //月冠魅力榜
	MonthlyPayPropertyAvatarType    ResPropertyAvatarType = 4 //月冠充值榜
)

type ResMedalObtainType = mysql.Type

const (
	WealthResMedalObtainType       ResMedalObtainType = 1
	CharmResMedalObtainType        ResMedalObtainType = 2
	GiftResMedalObtainType         ResMedalObtainType = 3
	BoomRocketResMedalObtainType   ResMedalObtainType = 4
	ActityResMedalObtainType       ResMedalObtainType = 5
	FruitKingResMedalObtainType    ResMedalObtainType = 6
	LuckyBoxKingResMedalObtainType ResMedalObtainType = 7
	VideoChatResMedalObtainType    ResMedalObtainType = 8
)

type ResGroupSupportGrade = mysql.Type

const (
	Agrade ResGroupSupportGrade = 1
	Bgrade ResGroupSupportGrade = 2
	Cgrade ResGroupSupportGrade = 3
	Dgrade ResGroupSupportGrade = 4
	Egrade ResGroupSupportGrade = 5
	Fgrade ResGroupSupportGrade = 6
	Ggrade ResGroupSupportGrade = 7
	Hgrade ResGroupSupportGrade = 8
	Igrade ResGroupSupportGrade = 9
	Jgrade ResGroupSupportGrade = 10
	Kgrade ResGroupSupportGrade = 11
	Lgrade ResGroupSupportGrade = 12
	Mgrade ResGroupSupportGrade = 13
	Ngrade ResGroupSupportGrade = 14
	Ograde ResGroupSupportGrade = 15
)
