package mic_c

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/config"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/_const/redis_key/mic_k"
	"time"
)

// 增加上麦邀请次数,一天只需要第一次进房弹出
// return show:true 今天已经展示过了
func IsMicDayInviteDialogShowToday(model *domain.Model, userId mysql.ID) (show bool, err error) {
	key := mic_k.GetUserMicDayInvite(userId)
	ttl := time.Hour * 24
	if !config.AppIsRelease() {
		ttl = time.Hour
	}
	lock, err := model.Redis.SetNX(model, key, 1, ttl).Result()
	if err != nil {
		model.Log.Errorf("IsMicDayInviteDialogShowToday uid:%v, fail:%v", userId, err)
		return false, err
	}
	// !lock = show
	return !lock, err
}
