package mic_c

import (
	"encoding/json"
	"git.hilo.cn/hilo-common/domain"
	"github.com/go-redis/redis/v8"
	"hilo-group/_const/redis_key/mic_k"
	"hilo-group/domain/event/mic_ev"
	"time"
)

// redis queue on mic
func QueueOnMic(model *domain.Model, onMic *mic_ev.OnMicEvent) error {
	queue := mic_k.GetOnMicQueue()
	onMic.Ts = time.Now().UnixNano() // 给一个时间戳
	body, _ := json.Marshal(onMic)
	return model.RedisCluster.RPush(model, queue, string(body)).Err()
}

// redis pop on mic
func BLPopQueueOnMic(model *domain.Model) *mic_ev.OnMicEvent {
	var res *mic_ev.OnMicEvent
	queue := mic_k.GetOnMicQueue()
	strs, err := model.RedisCluster.BLPop(model, time.Second, queue).Result()
	if err != nil {
		if err != redis.Nil {
			model.Log.Errorf("BLPopQueueOnMic fail:%v", err)
		}
		return nil
	}
	if len(strs) >= 2 {
		content := strs[1]
		res = new(mic_ev.OnMicEvent)
		if err := json.Unmarshal([]byte(content), res); err != nil {
			model.Log.Errorf("BLPopQueueOnMic json fail:%v", err)
			return nil
		}
		return res
	}
	return nil
}
