package mic_ev

import (
	"git.hilo.cn/hilo-common/domain"
)

var onMicListen = new(domain.EventBase)

// 在麦上事件
type OnMicEvent struct {
	GroupUuid  string // 群组uuid
	I          int    // 麦位
	ExternalId string // 麦中的人
	UserId     uint64 // 麦中的人
	Forbid     bool   // 静音 true:静音，false:没有静音
	Timestamp  int64  // 上麦的的时间戳

	Ts int64
}

func AddOnMicEventSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(onMicListen, callback)
}

func AddOnMicEventAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(onMicListen, callback)
}

func PublishOnMicEvent(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(onMicListen, model, event)
}
