package groupPower_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"github.com/jinzhu/now"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
	"hilo-group/_const/enum/groupPower_e"
	"time"
)

// 家族之星-月
type GroupPowerMonthStar struct {
	Month        string
	GroupPowerId mysql.ID
	UserId       mysql.ID
	Type         groupPower_e.GroupPowerStarType
	Score        mysql.Num
	LastCalTs    int64
	CreatedTime  time.Time `gorm:"->"`
	UpdatedTime  time.Time `gorm:"->"`
}

// 家族之星-日
type GroupPowerDayStar struct {
	Date         time.Time
	GroupPowerId mysql.ID
	UserId       mysql.ID
	Type         groupPower_e.GroupPowerStarType
	Score        mysql.Num
	LastCalTs    int64
	CreatedTime  time.Time `gorm:"->"`
	UpdatedTime  time.Time `gorm:"->"`
}

// 增加家族之星分数
// Deprecated: 用redis
func IncrGroupPowerMonthStarScore(model *domain.Model, groupPowerId, userId mysql.ID, _type groupPower_e.GroupPowerStarType, score mysql.Num, lastCalTs int64) error {
	month := time.Now().Format("200601")
	star := &GroupPowerMonthStar{
		Month:        month,
		GroupPowerId: groupPowerId,
		UserId:       userId,
		Type:         _type,
		Score:        score,
		LastCalTs:    lastCalTs,
	}
	if err := model.DB().Model(GroupPowerMonthStar{}).Clauses(clause.OnConflict{
		Columns: []clause.Column{{Name: "month"}, {Name: "group_power_id"}, {Name: "user_id"}, {Name: "type"}},
		DoUpdates: clause.Assignments(map[string]interface{}{
			"score":       gorm.Expr("score + ?", star.Score),
			"last_cal_ts": lastCalTs,
		}),
	}).Create(star).Error; err != nil {
		model.Log.Errorf("IncrGroupPowerMonthStarScore fail:%v", err)
		return err
	}
	return nil
}

// 增加家族之星分数
// Deprecated: 用redis代替
func IncrGroupPowerDayStarScore(model *domain.Model, groupPowerId, userId mysql.ID, _type groupPower_e.GroupPowerStarType, score mysql.Num, lastCalTs int64) error {
	star := &GroupPowerDayStar{
		Date:         time.Now(),
		GroupPowerId: groupPowerId,
		UserId:       userId,
		Type:         _type,
		Score:        score,
		LastCalTs:    lastCalTs,
	}
	if err := model.DB().Model(GroupPowerDayStar{}).Clauses(clause.OnConflict{
		Columns: []clause.Column{{Name: "date"}, {Name: "group_power_id"}, {Name: "user_id"}, {Name: "type"}},
		DoUpdates: clause.Assignments(map[string]interface{}{
			"score":       gorm.Expr("score + ?", star.Score),
			"last_cal_ts": lastCalTs,
		}),
	}).Create(star).Error; err != nil {
		model.Log.Errorf("IncrGroupPowerDayStarScore fail:%v", err)
		return err
	}
	return nil
}

// 获取家族之星排行
// Deprecated: 用redis
func GetGroupPowerMonthStarRank(model *domain.Model, groupPowerId mysql.ID, _type groupPower_e.GroupPowerStarType, offset, limit int, month string) ([]*GroupPowerMonthStar, error) {
	var res []*GroupPowerMonthStar
	//month := time.Now().Format("200601")
	if err := model.DB().Model(GroupPowerMonthStar{}).Where("month = ? AND group_power_id = ? AND `type` = ?", month, groupPowerId, _type).
		Order("score desc").Offset(offset).Limit(limit).Find(&res).Error; err != nil {
		model.Log.Errorf("GetGroupPowerMonthStarRank fail:%v", err)
		return res, err
	}
	return res, nil
}

// 获取家族之星排行
func GetGroupPowerStarRankPeriod(model *domain.Model, period string, groupPowerId mysql.ID, _type groupPower_e.GroupPowerStarType, offset, limit int) ([]*GroupPowerDayStar, error) {
	var res []*GroupPowerDayStar
	var startDate, endDate string
	switch period {
	case "day":
		startDate, endDate = time.Now().Format("2006-01-02"), time.Now().Format("2006-01-02")
	case "week":
		startDate = now.BeginningOfWeek().Format("2006-01-02")
		endDate = now.EndOfWeek().Format("2006-01-02")
	case "month":
		startDate = now.BeginningOfMonth().Format("2006-01-02")
		endDate = now.EndOfMonth().Format("2006-01-02")
	}
	if err := model.DB().Model(GroupPowerDayStar{}).Where("date BETWEEN ? AND ? AND group_power_id = ? AND `type` = ?", startDate, endDate, groupPowerId, _type).
		Select("user_id,SUM(score) as score").Group("user_id").
		Order("score desc").Offset(offset).Limit(limit).Find(&res).Error; err != nil {
		model.Log.Errorf("GetGroupPowerStarRankPeriod fail:%v", err)
		return res, err
	}
	for i := range res {
		res[i].Type = _type
	}
	return res, nil
}

// 获取家族之星三个排行榜的各自第一名
func GetGroupPowerMonthStartTop1(model *domain.Model, groupPowerId mysql.ID) ([]*GroupPowerDayStar, error) {
	var res []*GroupPowerDayStar
	r1, err := GetGroupPowerStarRankPeriod(model, "month", groupPowerId, groupPower_e.GroupPowerStarTypeFamous, 0, 1)
	if err != nil {
		return res, err
	}
	r2, err := GetGroupPowerStarRankPeriod(model, "month", groupPowerId, groupPower_e.GroupPowerStarTypeActive, 0, 1)
	if err != nil {
		return res, err
	}
	r3, err := GetGroupPowerStarRankPeriod(model, "month", groupPowerId, groupPower_e.GroupPowerStarTypeCharm, 0, 1)
	if err != nil {
		return res, err
	}
	res = append(res, r1...)
	res = append(res, r2...)
	res = append(res, r3...)
	return res, nil
}
