package luckyWheel_m

import (
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/_const/enum/luckyWheel_e"
	"time"
)

type LuckyWheel struct {
	mysql.Entity
	GroupId     string
	Creator     uint64
	CreatorJoin bool
	EntranceFee uint32
	AutoRestart bool
	PlayerNum   uint
	PlayTime    time.Time
	NextTime    time.Time
	Status      uint8
}

func (lw *LuckyWheel) Create(db *gorm.DB) error {
	return db.Create(lw).Error
}

func (lw *LuckyWheel) Get(db *gorm.DB) error {
	return db.Where(lw).First(lw).Error
}

func (lw *LuckyWheel) Remove(db *gorm.DB) (int64, error) {
	result := db.Where(lw).Delete(&LuckyWheel{})
	return result.RowsAffected, result.Error
}

func (lw *LuckyWheel) SetStatus(db *gorm.DB, status luckyWheel_e.LuckyWheelStatusType) error {
	if status == luckyWheel_e.ROLLING {
		return db.Model(&LuckyWheel{}).Where(lw).Updates(LuckyWheel{PlayTime: time.Now(), Status: status}).Error
	} else {
		return db.Model(&LuckyWheel{}).Where(lw).Update("status", status).Error
	}

}

func (lw *LuckyWheel) AddPlayNum(db *gorm.DB) (int64, error) {
	result := db.Model(&LuckyWheel{}).Where(lw).Update("player_num", gorm.Expr("player_num + 1"))
	return result.RowsAffected, result.Error
}

func (lw *LuckyWheel) SetNextTime(db *gorm.DB, nexTime time.Time) error {
	return db.Model(&LuckyWheel{}).Where(lw).Update("next_time", nexTime).Error
}

func GetTimeoutRecords(db *gorm.DB, status luckyWheel_e.LuckyWheelStatusType) ([]string, error) {
	rows := make([]LuckyWheel, 0)
	err := db.Where(&LuckyWheel{Status: status}).Where("next_time < now()").Find(&rows).Error
	if err != nil {
		return nil, err
	}
	result := make([]string, 0)
	for _, i := range rows {
		result = append(result, i.GroupId)
	}
	return result, nil
}

func GetCronTimeoutRecords(db *gorm.DB) ([]string, []string, []string, []string, error) {
	rows := make([]LuckyWheel, 0)
	err := db.Model(&LuckyWheel{}).Where("next_time < now()").Find(&rows).Error
	if err != nil {
		return nil, nil, nil, nil, err
	}
	//result := make([]string, 0)
	//for _, i := range rows {
	//	result = append(result, i.GroupId)
	//}

	//NONE    LuckyWheelStatusType = 0 // 没有活动/已结束
	//CREATED LuckyWheelStatusType = 1 // 创建，等待用户加入
	//ROLLING LuckyWheelStatusType = 2 // 转动中
	//SHOWING LuckyWheelStatusType = 3 // 结果展示中

	//三种情况
	timeOut := []string{} //过期退钱的
	finish := []string{}  //发钱的
	showEnd := []string{} //下一个的
	restart := []string{} // 需要创建新一轮的
	for i, _ := range rows {
		switch rows[i].Status {
		case luckyWheel_e.CREATED:
			timeOut = append(timeOut, rows[i].GroupId)
		case luckyWheel_e.ROLLING:
			finish = append(finish, rows[i].GroupId)
		case luckyWheel_e.SHOWING:
			showEnd = append(showEnd, rows[i].GroupId)
		case luckyWheel_e.RESTARTING:
			restart = append(restart, rows[i].GroupId)
		}
	}
	return timeOut, finish, showEnd, restart, nil
}

// 计算转盘钻石结果
func CalcDiamond(entranceFee uint32, num int) (uint32, uint32) {
	total := entranceFee * uint32(num)
	winnerDiamnod := total * luckyWheel_e.LUCKY_WHEEL_WINNER_PERCENTILE / 100
	ownerDiamnod := total * luckyWheel_e.LUCKY_WHEEL_OWNER_PERCENTILE / 100
	return winnerDiamnod, ownerDiamnod
}
