package res_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"gorm.io/gorm/clause"
	"hilo-group/_const/enum/gift_e"
	"hilo-group/myerr"
	"hilo-group/myerr/bizerr"
)

type ResGift struct {
	mysql.Entity
	//*domain.ModelBase `gorm:"-"`
	*domain.Model     `gorm:"-"`
	Name              mysql.Str
	IconUrl           mysql.Str
	SvagUrl           mysql.Str
	MusicUrl          mysql.Str
	Column            uint16
	DiamondNum        mysql.Num
	BeanNum           mysql.Num
	ReceiveDiamondNum mysql.Num
	Second            mysql.Num // obsolete
	N                 mysql.Num
	GroupBroadcast    bool
	Cp                bool
	Together          bool
	Status            mysql.UserYesNo
	GiftType          mysql.Type
}

func (rg *ResGift) FindValid(db *gorm.DB) ([]ResGift, error) {
	rows := make([]ResGift, 0)
	rg.Status = mysql.USER
	if err := db.Where(rg).Order("n ASC").Find(&rows).Error; err != nil {
		return nil, err
	}
	return rows, nil
}

type ResGiftAvatar struct {
	mysql.Entity
	//*domain.ModelBase `gorm:"-"`
	*domain.Model  `gorm:"-"`
	ResGiftId      mysql.ID
	Type           gift_e.ResGiftAvatarType
	SendUserId     mysql.ID
	ReceiverUserId mysql.ID
}

func (rga *ResGiftAvatar) Find(db *gorm.DB) ([]ResGiftAvatar, error) {
	rows := make([]ResGiftAvatar, 0)
	if err := db.Where(rga).Find(&rows).Error; err != nil {
		return nil, err
	}
	return rows, nil
}

func (rga *ResGiftAvatar) Save(db *gorm.DB) error {
	return db.Clauses(clause.OnConflict{
		DoUpdates: clause.AssignmentColumns([]string{"send_user_id"}),
	}).Create(rga).Error
}

func GetResGiftAvatar(model *domain.Model, t gift_e.ResGiftAvatarType) (ResGiftAvatar, error) {
	resGiftAvatar := ResGiftAvatar{}
	if err := model.Db.Model(&ResGiftAvatar{}).Where(&ResGiftAvatar{
		Type: t,
	}).First(&resGiftAvatar).Error; err != nil {
		return ResGiftAvatar{}, myerr.WrapErr(err)
	}
	return resGiftAvatar, nil
}

/**
 * 获取礼物
 **/
func GetGiftWithValid(model *domain.Model, id mysql.ID) (*ResGift, error) {
	var resGift ResGift
	if err := model.Db.First(&resGift, id).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	if resGift.Status == mysql.NOUSER {
		return nil, bizerr.ResGiftNoUser
	}
	return &resGift, nil
}

func (gift *ResGift) StatusToCancle() *ResGift {
	gift.Status = 1
	return gift
}

/**
 * 根据排序号查询礼物配置
 **/
func GetGiftByOrderId(model *domain.Model, n mysql.Num) (*ResGift, error) {
	var resGift ResGift
	if err := model.Db.Where("n = ?", n).First(&resGift).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	return &resGift, nil
}

/**
 * 添加礼物配置
 **/
func AddGiftConfig(model *domain.Model, input ResGift) error {
	return model.Db.Create(&input).Error
}

/**
 * 修改礼物配置
 **/
func UpdateGift(model *domain.Model, input ResGift) error {
	return model.Db.Omit("music_url", "GroupBroadcast", "cp", "together").Save(&input).Error
}

func UpdateGiftStatus(model *domain.Model, giftId mysql.ID, status mysql.UserYesNo) error {
	return model.Db.Table("res_gift").Where("id = ?", giftId).Update("status", status).Error
}

func GetGiftN(db *gorm.DB, n mysql.Num) ([]mysql.Num, error) {
	rows := make([]ResGift, 0)
	if err := db.Model(&ResGift{}).Where("n >= ?", n).Order("n").Find(&rows).Error; err != nil {
		return nil, err
	}
	result := make([]mysql.Num, 0)
	for _, i := range rows {
		result = append(result, i.N)
	}
	return result, nil
}

func UpdateGiftN(model *domain.Model, beginN, endN mysql.Num) error {
	return model.Db.Table("res_gift").Where("n >= ? AND n < ?", beginN, endN).Update("n", gorm.Expr("n+1")).Error
}

type GiftDetailInfo struct {
	IconUrl        string `json:"iconUrl"`
	SvgaUrl        string `json:"svgaUrl"`
	SenderAvatar   string `json:"senderAvatar"`   //key：sender_avatar
	ReceiverAvatar string `json:"receiverAvatar"` //key：receiver_avatar
}