package res_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"gorm.io/gorm"
	"hilo-group/myerr"
	"hilo-group/myerr/bizerr"
)

type ResHeadwear struct {
	mysql.Entity
	*domain.Model    `gorm:"-"`
	Name             mysql.Str
	PicUrl           mysql.Str
	EffectUrl        mysql.Str
	ReverseEffectUrl mysql.Str
}

func GetResHeadwearById(model *domain.Model, id mysql.ID) (*ResHeadwear, error) {
	resHeadwear := ResHeadwear{}
	if err := model.Db.Model(&ResHeadwear{}).First(&resHeadwear, id).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	resHeadwear.Model = model
	return &resHeadwear, nil
}

func GetResHeadwearMap(db *gorm.DB) (map[uint64]ResHeadwear, error) {
	rows := make([]ResHeadwear, 0)
	if err := db.Model(&ResHeadwear{}).Find(&rows).Error; err != nil {
		return nil, err
	}
	result := make(map[uint64]ResHeadwear, 0)
	for _, i := range rows {
		result[i.ID] = i
	}
	return result, nil
}

//矛盾，项目负责人（产品不接受 商品 同上架分开两个数据结构的模式），又在页面上要求头饰同价格在一起展示，修改。
//目前违背了，ResHeadwearDiamond 作为资源数据，不允许修改的特点。后果在于，对账错误。
type ResHeadwearDiamond struct {
	mysql.Entity
	*domain.Model `gorm:"-"`
	ResHeadwearId mysql.ID
	DiamondNum    mysql.Num
	Second        mysql.Num
	Status        mysql.UserYesNo
}

func InitResHeadwearDiamond(model *domain.Model, resHeadwearId mysql.ID, diamondNum mysql.Num, second mysql.Num) *ResHeadwearDiamond {
	return &ResHeadwearDiamond{
		Model:         model,
		ResHeadwearId: resHeadwearId,
		DiamondNum:    diamondNum,
		Second:        second,
		Status:        mysql.NOUSER,
	}
}

func GetResHeadwearDiamondByHeadwearIdOrNil(model *domain.Model, resHeadwearId mysql.ID) (*ResHeadwearDiamond, error) {
	resHeadwearDiamond := ResHeadwearDiamond{}
	if err := model.Db.Model(&ResHeadwearDiamond{}).Where(&ResHeadwearDiamond{
		ResHeadwearId: resHeadwearId,
	}).First(&resHeadwearDiamond).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return nil, nil
		} else {
			return nil, myerr.WrapErr(err)
		}
	}
	resHeadwearDiamond.Model = model
	return &resHeadwearDiamond, nil
}

func GetResHeadwearDiamond(model *domain.Model, resHeadwearDiamondId mysql.ID) (*ResHeadwearDiamond, error) {
	resHeadwearDiamond := ResHeadwearDiamond{}
	if err := model.Db.Model(&ResHeadwearDiamond{}).First(&resHeadwearDiamond, resHeadwearDiamondId).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	if resHeadwearDiamond.Status == mysql.NOUSER {
		return nil, bizerr.ResHeadwearDiamondNoUse
	}
	return &resHeadwearDiamond, nil
}

func (resHeadwearDiamond *ResHeadwearDiamond) SetDiamondNum(diamondNum uint32) *ResHeadwearDiamond {
	resHeadwearDiamond.DiamondNum = diamondNum
	return resHeadwearDiamond
}

func (resHeadwearDiamond *ResHeadwearDiamond) SetSecond(second uint32) *ResHeadwearDiamond {
	resHeadwearDiamond.Second = second
	return resHeadwearDiamond
}

//设置成未使用
func (resHeadwearDiamond *ResHeadwearDiamond) SetUser() *ResHeadwearDiamond {
	resHeadwearDiamond.Status = mysql.USER
	return resHeadwearDiamond
}

//设置成未使用
func (resHeadwearDiamond *ResHeadwearDiamond) SetNoUser() *ResHeadwearDiamond {
	resHeadwearDiamond.Status = mysql.NOUSER
	return resHeadwearDiamond
}

func CheckHeadwearValidById(model *domain.Model, id mysql.ID) (bool, error) {
	resHeadwear := ResHeadwear{}
	if err := model.Db.Model(&ResHeadwear{}).First(&resHeadwear, id).Error; err != nil {
		if err == gorm.ErrRecordNotFound {
			return false, nil
		} else {
			return false, myerr.WrapErr(err)
		}

	} else {
		return true, nil
	}
}

//id获取头饰，不存在则抛异常
func GetHeadwearById(model *domain.Model, id mysql.ID) (*ResHeadwear, error) {
	resHeadwear := ResHeadwear{}
	if err := model.Db.Model(&ResHeadwear{}).First(&resHeadwear, id).Error; err != nil {
		return nil, myerr.WrapErr(err)
	} else {
		resHeadwear.Model = model
		return &resHeadwear, nil
	}
}

func BatchGetHeadwearByIds(model *domain.Model, ids []mysql.ID) (map[uint64]ResHeadwear, error) {
	resHeadwears := []ResHeadwear{}
	if err := model.Db.Model(&ResHeadwear{}).Where("id in (?)", ids).Find(&resHeadwears).Error; err != nil {
		return nil, myerr.WrapErr(err)
	}
	resHeadwearMap := map[uint64]ResHeadwear{}
	for i, r := range resHeadwears {
		resHeadwearMap[r.ID] = resHeadwears[i]
	}
	return resHeadwearMap, nil
}

//初始化头饰,
func InitHeadwear(model *domain.Model, name string, picUrl string, effectUrl string) *ResHeadwear {
	return &ResHeadwear{
		Model:     model,
		Name:      name,
		PicUrl:    picUrl,
		EffectUrl: effectUrl,
	}
}

//修改头饰
func (resHeadwear *ResHeadwear) EditName(name string) *ResHeadwear {
	resHeadwear.Name = name
	return resHeadwear
}

func (resHeadwear *ResHeadwear) EditPicUrl(picUrl string) *ResHeadwear {
	resHeadwear.PicUrl = picUrl
	return resHeadwear
}

func (resHeadwear *ResHeadwear) EditEffectUrl(effectUrl string) *ResHeadwear {
	resHeadwear.EffectUrl = effectUrl
	return resHeadwear
}
