package test

import (
	"fmt"
	"net/url"
	"path"
	"strings"
	"testing"
)

func TestUrlParse(t *testing.T) {
	//rawUrl := "https://pkg.go.dev/net/url?a=b&c=d#example-ParseQuery"
	rawUrl := "https://pkg.go.dev/net/url"
	uri, err := url.Parse(rawUrl)
	if err != nil {
		return
	}
	query := uri.RawQuery
	queryArr := strings.Split(query, "&")
	v := url.Values{}
	if len(queryArr) > 0 {
		for _, q := range queryArr {
			if arr := strings.Split(q, "="); len(arr) == 2 {
				v.Add(arr[0], arr[1])
			}
		}
	}
	v.Add("v1", "v1")
	v.Add("v2", "v2")
	uri.RawQuery = v.Encode()
	uri.Path = path.Join(uri.Path, "/ccc/ddd")
	fmt.Println(fmt.Sprintf("修改后的URL是:%s", uri.String()))

}
