package user_e

import "git.hilo.cn/hilo-common/resource/mysql"

type ThirdPartyType = mysql.Type

const (
	Phone    ThirdPartyType = 1
	Google   ThirdPartyType = 2
	Facebook ThirdPartyType = 3
	Apple    ThirdPartyType = 4
	WeChat   ThirdPartyType = 5
)

type UserStatus mysql.Type

const (
	//正常
	UserStatusNormal UserStatus = 1
	//冻结
	UserStatusFrozen UserStatus = 2
)

type UserVipType = mysql.Type

const (
	// 男
	UserMan = 1
	// 女
	UserWomen = 2
)

type AwardType int

const (
	AwardTypeDiamond  AwardType = 1 // 钻石
	AwardTypeGift     AwardType = 2 // 背包礼物
	AwardTypeHeadwear AwardType = 3 // 头饰
	AwardTypeNoble    AwardType = 4 // 贵族
	AwardTypeRide     AwardType = 5 // 座驾
)

const (
	//购买
	UserVipTypeBuy UserVipType = 1
	//赠送
	UserVipTypeGive UserVipType = 2
)

type UserLikeOperateType = mysql.Type

const (
	//增加喜欢
	LikeAdd UserLikeOperateType = 1
	//取消喜欢
	LikeCancel UserLikeOperateType = 2
)

type UserLikeSceneType = mysql.Type

const (
	Match UserLikeSceneType = 1
	Video UserLikeSceneType = 2
)
