package tim_c

import (
	"git.hilo.cn/hilo-common/domain"
	"hilo-group/domain/cache/group_c"
	"time"
)

func setGroupMember(model *domain.Model, groupId string, extIds []string) error {
	err := BatchAddGroupMember(model, groupId, extIds)
	if err == nil {
		ret, err := group_c.SetGroupMemberTTL(groupId, time.Hour)
		model.Log.Infof("SetGroupMemberTTL %s, ret = %t, err: %v", groupId, ret, err)
	}
	return err
}

func BatchAddGroupMember(model *domain.Model, groupId string, extIds []string) error {
	ret, err := group_c.AddGroupMember(groupId, extIds)
	model.Log.Infof("BatchAddGroupMember %s, %v ret = %d, err: %v", groupId, extIds, ret, err)
	return err
}

func AddGroupMember(model *domain.Model, groupId string, extId string) error {
	ret, err := group_c.SetExists(groupId)
	if err != nil {
		model.Log.Infof("AddGroupMember %s, skip because set does not exist", groupId)
		return err
	}
	if ret == 0 {
		// 集合不存在，不要加进去！
		return nil
	}
	ret, err = group_c.AddGroupMember(groupId, []string{extId})
	model.Log.Infof("AddGroupMember %s, %s ret = %d, err: %v", groupId, extId, ret, err)
	return err
}

func RemoveGroupMember(model *domain.Model, groupId string, extId string) error {
	ret, err := group_c.RemoveGroupMember(groupId, extId)
	model.Log.Infof("RemoveGroupMember %s, %s ret = %d, err: %v", groupId, extId, ret, err)
	return err
}

func GetGroupMemberCount(model *domain.Model, groupId string) (uint, error) {
	ret, err := group_c.GetGroupMemberCard(groupId)
	model.Log.Infof("GetGroupMemberCount %s, ret = %d, err: %v", groupId, ret, err)
	return uint(ret), err
}
