package gift_ev

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/_const/enum/gift_e"
)

var sendGiftListen = new(domain.EventBase)

// 送礼事件
type SendGiftEvent struct {
	SendUserId       mysql.ID
	ReceiveUserIds   []mysql.ID
	ResGift          EventResGift
	GiftOperateIds   []mysql.ID
	GiftN            mysql.Num
	SceneType        gift_e.GiftOperateSceneType
	SceneUid         mysql.Str
	NoDiamondConsume bool   // 不要消费钻石
	TotalConsume     uint64 // 房间的总消费额
}

type EventResGift struct {
	ID                mysql.ID
	Name              mysql.Str
	IconUrl           mysql.Str
	SvgaUrl           mysql.Str
	MusicUrl          mysql.Str
	DiamondNum        mysql.Num
	BeanNum           mysql.Num
	ReceiveDiamondNum mysql.Num
	Second            mysql.Num
	N                 mysql.Num
	GroupBroadcast    bool
	Cp                bool
	Together          bool
	Status            mysql.UserYesNo
	GiftType          mysql.Type
}

func AddSendGiftEventSync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventSync(sendGiftListen, callback)
}

func AddSendGiftEventAsync(callback func(model *domain.Model, event interface{}) error) {
	domain.AddEventAsync(sendGiftListen, callback)
}

func PublishSendGiftEvent(model *domain.Model, event interface{}) error {
	return domain.PublishEvent(sendGiftListen, model, event)
}
