package user_m

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/myerr"
)

//获取用户的国家，和所属的区域（是否阿语区）
func GetUserCountryArea(model *domain.Model, id mysql.ID) (string, int, error) {
	type info struct {
		Name string
		Area int
	}
	res := new(info)
	if err := model.DB().Raw("select name, area from res_country where name = (select country from user where id = ?)", id).First(&res).Error; err != nil {
		return "", 0, myerr.WrapErr(err)
	}
	return res.Name, res.Area, nil
}
