package diamond_s

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/mycontext"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/common"
	"hilo-group/domain/model/diamond_m"
	"hilo-group/domain/model/groupPower_m"
	"hilo-group/domain/model/res_m"
	"hilo-group/myerr"
	"hilo-group/myerr/bizerr"
)

type DiamondService struct {
	svc *domain.Service
}

func NewDiamondService(myContext *mycontext.MyContext) *DiamondService {
	svc := domain.CreateService(myContext)
	return &DiamondService{svc}
}

// 币商转账钻石-家族限制检查
func (this *DiamondService) CheckDealerTransferFamilyLimit(dealerId, userId uint64, lang string) error {
	model := domain.CreateModelContext(this.svc.MyContext)
	// 代理、用户是否加入了家族
	dealerFamily, err := groupPower_m.GetGroupPowerUserOrNil(model, dealerId)
	if err != nil {
		return err
	}
	// 代理是否是家族代理
	isFamilyAgent, err := diamond_m.IsFamilyDiamondDealer(mysql.Db, dealerId)
	if err != nil {
		return err
	}

	userFamily, err := groupPower_m.GetGroupPowerUserOrNil(model, userId)
	if err != nil {
		return err
	}
	// 用户的家族是否有家族代理
	var userHasFamilyAgent bool
	if userFamily != nil {
		userHasFamilyAgent, err = groupPower_m.IsGroupPowerHasFamilyAgent(model, userFamily.GroupPowerId)
		if err != nil {
			return err
		}
	}
	if dealerFamily != nil && dealerFamily.GroupPowerId > 0 { // 代理加入了家族
		if isFamilyAgent && (userFamily == nil || userFamily.GroupPowerId != dealerFamily.GroupPowerId) { // 是家族代理：只能向本家族成员转移钻石，如果向非家族成员转移钻石，则提示“非家族成员”
			return myerr.WrapErr(res_m.GetErrByLanguage(model.Db, common.MSG_ID_NOT_FAMILY_MEMBER, lang, bizerr.GroupPowerDealerNotMember))
		}
		if !isFamilyAgent && userHasFamilyAgent { // 不是家族代理：如果用户加入了家族，且家族中有家族代理，那么也不能，“此用户已有家族代理，不能出售钻石”
			return myerr.WrapErr(res_m.GetErrByLanguage(model.Db, common.MSG_ID_DEALER_CAN_NOT_SOLE, lang, bizerr.GroupPowerDealerCanNotSole))
		}
	} else { // 代理没有加入家族的
		// 普通代理：不能向已经加入家族的成员（并且家族有家族代理）转移钻石，如果转移则提示“此用户已有家族代理，不能出售钻石”
		if userHasFamilyAgent {
			return myerr.WrapErr(res_m.GetErrByLanguage(model.Db, common.MSG_ID_DEALER_CAN_NOT_SOLE, lang, bizerr.GroupPowerDealerCanNotSole))
		}
	}
	return nil
}
