package group_s

import (
	"git.hilo.cn/hilo-common/domain"
	"git.hilo.cn/hilo-common/resource/mysql"
	"hilo-group/_const/enum/country_e"
	"hilo-group/domain/model/country_m"
	"hilo-group/domain/model/user_m"
	"hilo-group/myerr/bizerr"
)

// 检查是否App管理员
// 1. 全球广播管理员 gm
// 2. 国家管理员 cm
func (s *GroupService) CheckAppManager(userId mysql.ID) (gm bool, cm bool, err error) {
	var n int64
	if err := mysql.Db.Model(&user_m.GlobalBroadcastManager{}).Where(&user_m.GlobalBroadcastManager{UserId: userId}).Count(&n).Error; err != nil {
		return false, false, err
	}
	if n > 0 {
		gm = true
	}
	var _model = domain.CreateModel(s.svc.CtxAndDb)
	countryManager, err := country_m.GetCountryMgr(_model, userId)
	if err != nil {
		return false, false, err
	}
	if countryManager != nil && countryManager.Role == country_e.CountryMgrManager {
		cm = true
	}
	return
}

// 检查是否有重置/删除权限
// conditions
//  1. userId是国家管理员
//  2. userId和resetUserId是同国
//  3. resetUserId财富等级小于5级
// return
//  true: 有权限
//  err: 无权限的err
func (s *GroupService) CheckCountryManagerPermission(userId, resetUserId mysql.ID) (bool, error) {
	var _model = domain.CreateModel(s.svc.CtxAndDb)
	countryManager, err := country_m.GetCountryMgr(_model, userId)
	if err != nil {
		return false, err
	}
	if countryManager == nil || countryManager.Role != country_e.CountryMgrManager {
		return false, bizerr.ManagerNoPermission
	}
	user, err := user_m.GetUser(_model, resetUserId)
	if err != nil {
		return false, err
	}
	grade, _, err := user_m.GetWealthGrade(_model, resetUserId)
	if err != nil {
		return false, err
	}
	if grade >= 5 || countryManager.Country != user.Country {
		return false, bizerr.ManagerNoUserPermission
	}
	return true, nil
}
